/*
 * Copyright 2002, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bql;

import javax.baja.collection.BITable;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIRelational is an interface for an object that manages relational data.
 *
 * @author    John Sublett
 */
public interface BIRelational<T extends BIObject>
{
  /**
   * Get the relation with the specified identifier.
   *
   * @param id A string identifier for the relation.  The format
   *   of the string is implementation specific.
   *
   * @param cx The Context associated with this request.
   *           This parameter was added starting in Niagara 4.0.
   *
   * @return Returns the relation identified by id or null if the relation
   *   cannot be found.
   */
  BITable<T> getRelation(String id, Context cx);
  
  Type TYPE = Sys.loadType(BIRelational.class);
}
