/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bql;

import javax.baja.agent.*;
import javax.baja.sys.*;

/**
 * BIBqlFilter is a BIFilter that can provide a predicate for
 * a BQL query.
 *
 * @author    John Sublett
 * @creation  16 Oct 2003
 * @version   $Revision: 5$ $Date: 8/22/07 4:23:49 PM EDT$
 * @since     Baja 1.0
 */
public interface BIBqlFilter
  extends BInterface, BIAgent
{
  public static final Type TYPE = Sys.loadType(BIBqlFilter.class);
  
  /**
   * Initialize the filter for objects of the same type
   * as the specified object.  This allows subclass specific
   * behavior for classes
   */
  public void init(BObject o);
  
  /**
   * Get the predicate text for this filter using the
   * specified column name.
   * <p>
   * Example:
   *   For a float value filter and a column name of "x":
   *   "x >= 0 and x <= 100"
   * 
   * @param columnName The name of the column to use in the
   *   predicate expression.
   */
  public String getPredicate(String columnName);
  
  /**
   * Test an object to see if it falls within the range of this filter.
   *
   * @param o The object to be tested.
   */
  public boolean accept(BObject o);
}
