/*
 * Copyright 2012 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.box;

import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * <p>Represents a BOX client environment. Every client environment for BOX
 * should extend this class.</p>
 *
 * @author    gjohnson on 20 Oct 2010
 * @since     Niagara 3.7
 */
public abstract class BBoxClientEnv
    extends BSingleton
{
  protected BBoxClientEnv() {}

  /**
   * @since Niagara 4.2
   * @return the kind of runtime environment in which this client environment is
   * currently operating.
   */
  public abstract EnvironmentType getEnvironmentType();

  /**
   * The different types of environments in which BOX can currently operate.
   */
  public enum EnvironmentType
  {
    STATION,
    WORKBENCH
  }
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBoxClientEnv.class);
}
