/**
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.status.BStatusValue;
import javax.baja.util.ICoalesceable;
import com.tridium.basicdriver.point.BBasicProxyExt;

/**
 * The BasicWriteAsyncRequest class is used to initiate a call to 
 * doWrite on BasicProxyExtensions on the coalescing request thread.
 *
 * @author    Lenard Perkins  
 * @creation  15 Mar 03
 * @version   $Revision: 1$ $Date: 03/15/05 09:15:14 AM$  
 * @since     Niagara 3.0 basicdriver 1.0     
 */ 

public class BasicWriteAsyncRequest
  implements Runnable, ICoalesceable
{

  /**
   * Constructor
   */
  public BasicWriteAsyncRequest(BBasicProxyExt proxyExt, BStatusValue out)
  {
    this.hashCode = proxyExt.hashCode();
    this.proxyExt = proxyExt;
    this.out = out;
  }

 /**
  * Calls doWrite() on the BasicWriteProxyExt.
  */
  public void run()
  {
    try
    {
      if (proxyExt != null)
        proxyExt.doWrite(out);
    }
    catch (Throwable t) // LP - Ensures that writeFail is called, otherwise, the point locks up. I noticed this by empirical analysis. In other words, it happened to me when my driver's doWrite method blew a runtime exception
    {
      proxyExt.writeFail(t.toString());
      if (t instanceof ThreadDeath) // Sun JavaSoft highly recommends this practice when catching Throwable
        throw (ThreadDeath)t;
    }
  }

////////////////////////////////////////////////////////////////
// ICoalesceable
////////////////////////////////////////////////////////////////
  
  /**
   * Hash code is based on the source BBasicProxyExt.
   */
  public int hashCode()
  {                             
    return hashCode;
  }             
  
  /**
   * Equality is based on the source BBasicProxyExt.
   */
  public boolean equals(Object object)
  {                                  
    if (object instanceof BasicWriteAsyncRequest)
    {                               
      BasicWriteAsyncRequest o = (BasicWriteAsyncRequest)object;
      return proxyExt == o.proxyExt;
    }
    return false;
  }
  
  /**
   * Return this.
   */
  public Object getCoalesceKey()
  {
    return this;
  }
  
  /**
   * Return c - last Invocation wins.
   */
  public ICoalesceable coalesce(ICoalesceable c)
  {                                 
    return c;  
  }
                 
////////////////////////////////////////////////////////////////
// Debug
////////////////////////////////////////////////////////////////
  
  /**
   * Get a String representation.
   */
  public String toString()
  {
    return "BasicWriteAsyncRequest (proxyExt=" + proxyExt + ", writeValue=" + out + ")";
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  protected int hashCode;
  protected BBasicProxyExt proxyExt;
  protected BStatusValue out;
  
}
