/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.sys.BajaRuntimeException;

/**
 * A BasicException is thrown when an error occurs in the
 * basic driver.
 *
 * @author    Scott Hoye
 * @creation  01 Apr 02
 * @version   $Revision: 1$ $Date: 04/01/02 12:47:14 PM$
 * @since     Niagara 3.0 basicdriver 1.0
 */

public class BasicException
  extends BajaRuntimeException
{

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with specified message and nested exception.
   */
  public BasicException(String msg, Throwable cause)
  {  
    super(msg, cause);
  }

  /**
   * Constructor with specified nested exception.
   */
  public BasicException(Throwable cause)
  {  
    super(cause);
  }

  /**
   * Constructor with specified message.
   */
  public BasicException(String msg)
  {  
    super(msg);
  }
  
}
