/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.driver.util.BIPollable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The basic pollable interface is implemented by objects that
 * wish to register to receive poll requests from the BBasicPollScheduler
 *  
 * @author    Scott Hoye
 * @creation  02 Apr 02
 * @version   $Revision: 1$ $Date: 04/02/02 2:56:44 PM$
 * @since     Niagara 3.0 basicdriver 1.0
 */
public interface BIBasicPollable
  extends BIPollable
{
  /**
   * The poll() callback method called from BBasicPollScheduler
   * when it is time to poll this object.
   */
  public void poll();
  
  public static final Type TYPE = Sys.loadType(BIBasicPollable.class);

}