/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/**
 * BBasicWorker manages a basic worker thread for a queue.
 *
 * @author    Scott Hoye
 * @creation  16 Feb 04
 * @version   $Revision: 1$ $Date: 2/16/2004 1:39:19 PM$
 * @since     Niagara 3.0 basicdriver 1.0
 */
public class BBasicWorker
  extends BWorker
{
  /*-

  class BBasicWorker
  {
    properties
    {
      maxQueueSize: int
        -- the size of the working queue
        default {[ 256 ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.basicdriver.util.BBasicWorker(2710012915)1.0$ @*/
/* Generated Wed Feb 18 09:04:44 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "maxQueueSize"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxQueueSize</code> property.
   * the size of the working queue
   * @see com.tridium.basicdriver.util.BBasicWorker#getMaxQueueSize
   * @see com.tridium.basicdriver.util.BBasicWorker#setMaxQueueSize
   */
  public static final Property maxQueueSize = newProperty(0, 256,null);

  /**
   * Get the <code>maxQueueSize</code> property.
   * @see com.tridium.basicdriver.util.BBasicWorker#maxQueueSize
   */
  public int getMaxQueueSize() { return getInt(maxQueueSize); }

  /**
   * Set the <code>maxQueueSize</code> property.
   * @see com.tridium.basicdriver.util.BBasicWorker#maxQueueSize
   */
  public void setMaxQueueSize(int v) { setInt(maxQueueSize,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBasicWorker.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BBasicWorker
////////////////////////////////////////////////////////////////

  /**
   * Post a runnable request to the working queue.
   */
  public final IFuture post(Runnable r)
  {
    if (!isRunning() || queue == null)
      throw new NotRunningException();
    queue.enqueue(r);
    return null;
  }

  /**
   * Create the working queue with the given size.
   */
  protected Queue makeQueue(int size)
  {
    return new Queue(size);
  }

////////////////////////////////////////////////////////////////
// BWorker Overrides
////////////////////////////////////////////////////////////////

  /**
   * Start running this task.
   */
  public final Worker getWorker()
  {
    if (worker == null)
    {
      queue = makeQueue(getMaxQueueSize());
      worker = new Worker(queue);
    }
    return worker;
  }

  /**
   * Get the number of entries currently in the queue
   */
  public int getSize()
  {
    return queue.size();
  }

  /**
   * Get the max number of entries the queue can handle
   */
  public int getMaxSize()
  {
    return queue.maxSize();
  }

  protected String getWorkerThreadName()
  {
    return "BscWkr:" + getParent().getName() + ":" + getName();
  }

////////////////////////////////////////////////////////////////
// BComponent Overrides
////////////////////////////////////////////////////////////////

  /**
   * Callback when a property (or possibly a ancestor of
   * that property) is modified on this component.
   */
  public void changed(Property property, Context context)
  {
    super.changed(property, context);
    if (!isRunning())
    {
      return;
    }

    if (property.equals(maxQueueSize))
    {
      if (queue != null)
      {
        stopWorker();
        queue = null;
        worker = null;
        getWorker();
        startWorker();

// OLD CODE
//        synchronized(queue)
//        {
//          // Make a new queue of the new size and fill it with the current queue's entries.
//          Queue temp = makeQueue(getMaxQueueSize());
//          int size = queue.size();
//          if (size > getMaxQueueSize()) size = getMaxQueueSize();
//          for (int i = 0; i < size; i++)
//          {
//            try
//            {
//              temp.enqueue(queue.dequeue());
//            }
//            catch (Exception e) {}
//          }
//          queue.clear();
//          queue = temp;
//        }
      }
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private Queue queue = null;
  private Worker worker = null;

////////////////////////////////////////////////////////////////
// Old
////////////////////////////////////////////////////////////////

  protected final void basicWorkerChanged(Property property, Context context) {}

}
