/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;

/**
 * BBasicCoalescingWorker manages a basic worker thread for a coalescing queue.
 *
 * @author    Scott Hoye
 * @creation  16 Feb 04
 * @version   $Revision: 1$ $Date: 2/16/2004 1:39:19 PM$
 * @since     Niagara 3.0 basicdriver 1.0 
 */
public class BBasicCoalescingWorker
  extends BBasicWorker
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBasicCoalescingWorker.class);

////////////////////////////////////////////////////////////////
// BBasicWorker Overrides
////////////////////////////////////////////////////////////////
  
  /**
   * Create the working queue with the given size.
   * Overridden here to create a coalescing queue.
   */
  protected Queue makeQueue(int size)
  {
    return new CoalesceQueue(size);
  }
  
  protected String getWorkerThreadName()
  {                
    return "BscClscWkr:" + getParent().getName() + ":" + getName();
  }

}
