/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver;

import com.tridium.basicdriver.message.ReceivedMessage;

/**
 * The unsolicited message listener interface is implemented by objects that
 * wish to register to receive unsolicited messages from the Comm.
 *  
 * @author    Scott Hoye
 * @creation  02 Apr 02
 * @version   $Revision: 1$ $Date: 04/02/02 2:56:44 PM$
 * @since     Niagara 3.0 basicdriver 1.0
 */
public interface UnsolicitedMessageListener
{
  /**
   * Receive an unsolicited message from Comm.
   */
  public void receiveMessage(ReceivedMessage msg);
  
  /**
   * Returns an unsolicited listener code object associated with
   * this listener to use for matching unsolicited received messages
   * that should be routed to this listener.
   */
  public Object getUnsolicitedListenerCode();
}