/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver;

import com.tridium.basicdriver.message.Message;

/**
 * MessageListener is implemented by objects which can 
 * receive a response Message.  It should be implemented by
 * objects who are the source of AsyncMessageRequests or AsyncWriteMessageRequests
 * in order to handle the asynchronous response.
 *
 * @author    Scott Hoye
 * @creation  12 Feb 04
 * @version   $Revision: 1$ $Date: 2/12/2004 10:03:14 AM$
 * @since     Niagara 3.0 basicdriver 1.0
 */
public interface MessageListener
{     
  
  /**
   * Implementers should process the received Message.
   */
  public void processMessage(Message response);
      
}
