/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver;

import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBasicDevice is the base class for Basic devices.
 *
 * @author    Scott Hoye       
 * @creation  22 Mar 02
 * @version   $Revision: 1$ $Date: 03/22/02 12:47:14 PM$  
 * @since     Niagara 3.0 basicdriver 1.0
 */
public abstract class BBasicDevice
  extends BLoadableDevice
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBasicDevice.class);

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  public Type getNetworkType()
  {
    return BBasicNetwork.TYPE;
  }

}