/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.text;

import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.options.*;

/**
 * The BTextEditorOptions stores the options used to
 * configure text entry.
 *
 * @author    Brian Frank
 * @creation  6 Jul 01
 * @version   $Revision: 14$ $Date: 4/27/05 9:29:31 AM EDT$
 * @since     Baja 1.0
 */
public class BTextEditorOptions
  extends BUserOptions
{ 

  /*-
  
  class BTextEditorOptions
  {
    properties
    {
      showSpaces: boolean
        -- Should spaces be shown while editing text.
        default {[ false ]}
      showTabs: boolean
        -- Should tabs be shown while editing text.
        default {[ false ]}
      showNewlines: boolean
        -- Should newlines be shown while editing text.
        default {[ false ]}
      tabToSpaceConversion: int 
        -- This is the number of space characters that a
        -- tab occupies in the text editor.
        default {[ 2 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(0)) ]}
      showMargin: int
        -- Display a vertical line at the specified column index,
        -- or zero to disable this feature.
        default {[ 0 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(0)) ]}
      colorCoding: BColorCoding
        -- Stores the color coding for the segment types.
        default {[ new BColorCoding() ]}
      keyBindings: BKeyBindings
        -- Stores the key to command bindings.
        default {[ new BKeyBindings() ]}
      undoNavigation: boolean
        -- If true then cursor movement is added to the
        -- undo stack, otherwise only true edits are
        -- added to the undo stack.
        default {[ true ]}    
      matchParens: boolean
        -- Match parenthesis "(...)" as they are typed.
        default {[ true ]}
      matchBraces: boolean
        -- Match braces "{...}" as they are typed.
        default {[ true ]}
      matchBrackets: boolean
        -- Match brackets "[...]" as they are typed.
        default {[ true ]}
      wordRightToEndOfWord: boolean
        -- If true, the word right command moves to the end of the
        -- next word, otherwise it moves to the beginning of the
        -- next word.
        default {[ true ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.text.BTextEditorOptions(2306971131)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "showSpaces"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showSpaces</code> property.
   * Should spaces be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#getShowSpaces
   * @see javax.baja.ui.text.BTextEditorOptions#setShowSpaces
   */
  public static final Property showSpaces = newProperty(0, false,null);
  
  /**
   * Get the <code>showSpaces</code> property.
   * Should spaces be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showSpaces
   */
  public boolean getShowSpaces() { return getBoolean(showSpaces); }
  
  /**
   * Set the <code>showSpaces</code> property.
   * Should spaces be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showSpaces
   */
  public void setShowSpaces(boolean v) { setBoolean(showSpaces,v,null); }

////////////////////////////////////////////////////////////////
// Property "showTabs"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showTabs</code> property.
   * Should tabs be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#getShowTabs
   * @see javax.baja.ui.text.BTextEditorOptions#setShowTabs
   */
  public static final Property showTabs = newProperty(0, false,null);
  
  /**
   * Get the <code>showTabs</code> property.
   * Should tabs be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showTabs
   */
  public boolean getShowTabs() { return getBoolean(showTabs); }
  
  /**
   * Set the <code>showTabs</code> property.
   * Should tabs be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showTabs
   */
  public void setShowTabs(boolean v) { setBoolean(showTabs,v,null); }

////////////////////////////////////////////////////////////////
// Property "showNewlines"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showNewlines</code> property.
   * Should newlines be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#getShowNewlines
   * @see javax.baja.ui.text.BTextEditorOptions#setShowNewlines
   */
  public static final Property showNewlines = newProperty(0, false,null);
  
  /**
   * Get the <code>showNewlines</code> property.
   * Should newlines be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showNewlines
   */
  public boolean getShowNewlines() { return getBoolean(showNewlines); }
  
  /**
   * Set the <code>showNewlines</code> property.
   * Should newlines be shown while editing text.
   * @see javax.baja.ui.text.BTextEditorOptions#showNewlines
   */
  public void setShowNewlines(boolean v) { setBoolean(showNewlines,v,null); }

////////////////////////////////////////////////////////////////
// Property "tabToSpaceConversion"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tabToSpaceConversion</code> property.
   * This is the number of space characters that a tab occupies in the text editor.
   * @see javax.baja.ui.text.BTextEditorOptions#getTabToSpaceConversion
   * @see javax.baja.ui.text.BTextEditorOptions#setTabToSpaceConversion
   */
  public static final Property tabToSpaceConversion = newProperty(0, 2,BFacets.make(BFacets.MIN, BInteger.make(0)));
  
  /**
   * Get the <code>tabToSpaceConversion</code> property.
   * This is the number of space characters that a tab occupies in the text editor.
   * @see javax.baja.ui.text.BTextEditorOptions#tabToSpaceConversion
   */
  public int getTabToSpaceConversion() { return getInt(tabToSpaceConversion); }
  
  /**
   * Set the <code>tabToSpaceConversion</code> property.
   * This is the number of space characters that a tab occupies in the text editor.
   * @see javax.baja.ui.text.BTextEditorOptions#tabToSpaceConversion
   */
  public void setTabToSpaceConversion(int v) { setInt(tabToSpaceConversion,v,null); }

////////////////////////////////////////////////////////////////
// Property "showMargin"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showMargin</code> property.
   * Display a vertical line at the specified column index,
   * or zero to disable this feature.
   * @see javax.baja.ui.text.BTextEditorOptions#getShowMargin
   * @see javax.baja.ui.text.BTextEditorOptions#setShowMargin
   */
  public static final Property showMargin = newProperty(0, 0,BFacets.make(BFacets.MIN, BInteger.make(0)));
  
  /**
   * Get the <code>showMargin</code> property.
   * Display a vertical line at the specified column index,
   * or zero to disable this feature.
   * @see javax.baja.ui.text.BTextEditorOptions#showMargin
   */
  public int getShowMargin() { return getInt(showMargin); }
  
  /**
   * Set the <code>showMargin</code> property.
   * Display a vertical line at the specified column index,
   * or zero to disable this feature.
   * @see javax.baja.ui.text.BTextEditorOptions#showMargin
   */
  public void setShowMargin(int v) { setInt(showMargin,v,null); }

////////////////////////////////////////////////////////////////
// Property "colorCoding"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>colorCoding</code> property.
   * Stores the color coding for the segment types.
   * @see javax.baja.ui.text.BTextEditorOptions#getColorCoding
   * @see javax.baja.ui.text.BTextEditorOptions#setColorCoding
   */
  public static final Property colorCoding = newProperty(0, new BColorCoding(),null);
  
  /**
   * Get the <code>colorCoding</code> property.
   * Stores the color coding for the segment types.
   * @see javax.baja.ui.text.BTextEditorOptions#colorCoding
   */
  public BColorCoding getColorCoding() { return (BColorCoding)get(colorCoding); }
  
  /**
   * Set the <code>colorCoding</code> property.
   * Stores the color coding for the segment types.
   * @see javax.baja.ui.text.BTextEditorOptions#colorCoding
   */
  public void setColorCoding(BColorCoding v) { set(colorCoding,v,null); }

////////////////////////////////////////////////////////////////
// Property "keyBindings"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>keyBindings</code> property.
   * Stores the key to command bindings.
   * @see javax.baja.ui.text.BTextEditorOptions#getKeyBindings
   * @see javax.baja.ui.text.BTextEditorOptions#setKeyBindings
   */
  public static final Property keyBindings = newProperty(0, new BKeyBindings(),null);
  
  /**
   * Get the <code>keyBindings</code> property.
   * Stores the key to command bindings.
   * @see javax.baja.ui.text.BTextEditorOptions#keyBindings
   */
  public BKeyBindings getKeyBindings() { return (BKeyBindings)get(keyBindings); }
  
  /**
   * Set the <code>keyBindings</code> property.
   * Stores the key to command bindings.
   * @see javax.baja.ui.text.BTextEditorOptions#keyBindings
   */
  public void setKeyBindings(BKeyBindings v) { set(keyBindings,v,null); }

////////////////////////////////////////////////////////////////
// Property "undoNavigation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>undoNavigation</code> property.
   * If true then cursor movement is added to the undo stack, otherwise only true edits are added to the undo stack.
   * @see javax.baja.ui.text.BTextEditorOptions#getUndoNavigation
   * @see javax.baja.ui.text.BTextEditorOptions#setUndoNavigation
   */
  public static final Property undoNavigation = newProperty(0, true,null);
  
  /**
   * Get the <code>undoNavigation</code> property.
   * If true then cursor movement is added to the undo stack, otherwise only true edits are added to the undo stack.
   * @see javax.baja.ui.text.BTextEditorOptions#undoNavigation
   */
  public boolean getUndoNavigation() { return getBoolean(undoNavigation); }
  
  /**
   * Set the <code>undoNavigation</code> property.
   * If true then cursor movement is added to the undo stack, otherwise only true edits are added to the undo stack.
   * @see javax.baja.ui.text.BTextEditorOptions#undoNavigation
   */
  public void setUndoNavigation(boolean v) { setBoolean(undoNavigation,v,null); }

////////////////////////////////////////////////////////////////
// Property "matchParens"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>matchParens</code> property.
   * Match parenthesis "(...)" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#getMatchParens
   * @see javax.baja.ui.text.BTextEditorOptions#setMatchParens
   */
  public static final Property matchParens = newProperty(0, true,null);
  
  /**
   * Get the <code>matchParens</code> property.
   * Match parenthesis "(...)" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchParens
   */
  public boolean getMatchParens() { return getBoolean(matchParens); }
  
  /**
   * Set the <code>matchParens</code> property.
   * Match parenthesis "(...)" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchParens
   */
  public void setMatchParens(boolean v) { setBoolean(matchParens,v,null); }

////////////////////////////////////////////////////////////////
// Property "matchBraces"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>matchBraces</code> property.
   * Match braces "{...}" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#getMatchBraces
   * @see javax.baja.ui.text.BTextEditorOptions#setMatchBraces
   */
  public static final Property matchBraces = newProperty(0, true,null);
  
  /**
   * Get the <code>matchBraces</code> property.
   * Match braces "{...}" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchBraces
   */
  public boolean getMatchBraces() { return getBoolean(matchBraces); }
  
  /**
   * Set the <code>matchBraces</code> property.
   * Match braces "{...}" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchBraces
   */
  public void setMatchBraces(boolean v) { setBoolean(matchBraces,v,null); }

////////////////////////////////////////////////////////////////
// Property "matchBrackets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>matchBrackets</code> property.
   * Match brackets "[...]" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#getMatchBrackets
   * @see javax.baja.ui.text.BTextEditorOptions#setMatchBrackets
   */
  public static final Property matchBrackets = newProperty(0, true,null);
  
  /**
   * Get the <code>matchBrackets</code> property.
   * Match brackets "[...]" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchBrackets
   */
  public boolean getMatchBrackets() { return getBoolean(matchBrackets); }
  
  /**
   * Set the <code>matchBrackets</code> property.
   * Match brackets "[...]" as they are typed.
   * @see javax.baja.ui.text.BTextEditorOptions#matchBrackets
   */
  public void setMatchBrackets(boolean v) { setBoolean(matchBrackets,v,null); }

////////////////////////////////////////////////////////////////
// Property "wordRightToEndOfWord"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>wordRightToEndOfWord</code> property.
   * If true, the word right command moves to the end of
   * the next word, otherwise it moves to the beginning
   * of the next word.
   * @see javax.baja.ui.text.BTextEditorOptions#getWordRightToEndOfWord
   * @see javax.baja.ui.text.BTextEditorOptions#setWordRightToEndOfWord
   */
  public static final Property wordRightToEndOfWord = newProperty(0, true,null);
  
  /**
   * Get the <code>wordRightToEndOfWord</code> property.
   * If true, the word right command moves to the end of
   * the next word, otherwise it moves to the beginning
   * of the next word.
   * @see javax.baja.ui.text.BTextEditorOptions#wordRightToEndOfWord
   */
  public boolean getWordRightToEndOfWord() { return getBoolean(wordRightToEndOfWord); }
  
  /**
   * Set the <code>wordRightToEndOfWord</code> property.
   * If true, the word right command moves to the end of
   * the next word, otherwise it moves to the beginning
   * of the next word.
   * @see javax.baja.ui.text.BTextEditorOptions#wordRightToEndOfWord
   */
  public void setWordRightToEndOfWord(boolean v) { setBoolean(wordRightToEndOfWord,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTextEditorOptions.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BOptions
////////////////////////////////////////////////////////////////
  
  /**
   * Get the default instance of the options.
   */
  public static BTextEditorOptions make()
  {
    if (options == null)                        
    {                 
      BWidgetApplication app = BWidget.getApplication();     
      if (app != null)
        options = (BTextEditorOptions)app.getOptionsManager().load(TYPE);
      else
        options = new BTextEditorOptions();
    }
    return options;
  }
  private static BTextEditorOptions options;

  
////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == keyBindings) getKeyBindings().updateTable();
  }

}
