/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.ui.shape;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.*;

import com.tridium.ui.ShellManager;

/**
 * BShape is the base for widgets which render a geometric shape.
 *
 * @author    Brian Frank
 * @creation  2 Apr 04
 * @version   $Revision: 5$ $Date: 3/28/05 10:32:30 AM EST$
 * @since     Baja 1.0
 */
public abstract class BShape
  extends BWidget
{          

  /*-
  
  class BShape
  {
    properties
    {        
      fill: BBrush        
        -- The brush used to fill the shape interior.
        default {[ BBrush.NULL ]}
      stroke: BBrush
        -- The brush used to fill the shapes stroke.
        default {[ BBrush.NULL ]}
      pen: BPen
        -- The pen used to draw the shapes stroke.
        default {[ BPen.DEFAULT ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BShape(828406656)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "fill"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fill</code> property.
   * The brush used to fill the shape interior.
   * @see javax.baja.ui.shape.BShape#getFill
   * @see javax.baja.ui.shape.BShape#setFill
   */
  public static final Property fill = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>fill</code> property.
   * The brush used to fill the shape interior.
   * @see javax.baja.ui.shape.BShape#fill
   */
  public BBrush getFill() { return (BBrush)get(fill); }
  
  /**
   * Set the <code>fill</code> property.
   * The brush used to fill the shape interior.
   * @see javax.baja.ui.shape.BShape#fill
   */
  public void setFill(BBrush v) { set(fill,v,null); }

////////////////////////////////////////////////////////////////
// Property "stroke"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stroke</code> property.
   * The brush used to fill the shapes stroke.
   * @see javax.baja.ui.shape.BShape#getStroke
   * @see javax.baja.ui.shape.BShape#setStroke
   */
  public static final Property stroke = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>stroke</code> property.
   * The brush used to fill the shapes stroke.
   * @see javax.baja.ui.shape.BShape#stroke
   */
  public BBrush getStroke() { return (BBrush)get(stroke); }
  
  /**
   * Set the <code>stroke</code> property.
   * The brush used to fill the shapes stroke.
   * @see javax.baja.ui.shape.BShape#stroke
   */
  public void setStroke(BBrush v) { set(stroke,v,null); }

////////////////////////////////////////////////////////////////
// Property "pen"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pen</code> property.
   * The pen used to draw the shapes stroke.
   * @see javax.baja.ui.shape.BShape#getPen
   * @see javax.baja.ui.shape.BShape#setPen
   */
  public static final Property pen = newProperty(0, BPen.DEFAULT,null);
  
  /**
   * Get the <code>pen</code> property.
   * The pen used to draw the shapes stroke.
   * @see javax.baja.ui.shape.BShape#pen
   */
  public BPen getPen() { return (BPen)get(pen); }
  
  /**
   * Set the <code>pen</code> property.
   * The pen used to draw the shapes stroke.
   * @see javax.baja.ui.shape.BShape#pen
   */
  public void setPen(BPen v) { set(pen,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BShape.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Constructor with geometry, fill, stroke, and pen.
   */
  protected BShape(BGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    setShapeGeom(geom);                                            
    setFill(fill);
    setStroke(stroke);
    setPen(pen);
  } 

  /**
   * Constructor with geometry.
   */
  protected BShape(BGeom geom)
  {                           
    setShapeGeom(geom);
  } 

  /**
   * Default constructor.
   */
  protected BShape()
  {
  } 

////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Get the BGeom of this shape.  Subclasses define a 
   * property called "geom" with their specified BGeom type.
   */
  public abstract BGeom getShapeGeom();

  /**
   * Set the BGeom of this shape.  Subclasses define a 
   * property called "geom" with their specified BGeom type.
   */
  public abstract void setShapeGeom(BGeom geom);
  
////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////

  /**
   * Shapes do not receive input events 
   * unless hasBindings() returns true. 
   */
  public boolean receiveInputEvents()
  {
    return hasBindings();
  }
  
  /**
   * Return if the geometry contains the point.
   */                                          
  public boolean contains(double x, double y)
  {
    return getShapeGeom().contains(x, y);
  }
  
  /**
   * Paint the geometry using fill, stroke, and pen.
   */
  public void paint(Graphics g)
  {            
    boolean forceStroke = false;
    BGeom geom = getShapeGeom();
    
    BBrush fill = getFill();
    if (!fill.isNull())
    {
      g.setBrush(fill);
      g.fill(geom);
    }
    BBrush stroke = getStroke();

    if (fill.isNull() && stroke.isNull())
    {
      ShellManager manager = getShellManager();
      forceStroke = manager != null && manager.paintTranslucentShapes();
    }


    if (!stroke.isNull() || forceStroke)
    {
      g.setBrush(stroke);
      g.setPen(getPen());
      g.stroke(geom);
    }
  }              

  
////////////////////////////////////////////////////////////////
// Contain Testing
////////////////////////////////////////////////////////////////
  
  /*
  public void mouseEntered(BMouseEvent event)
  {
    realFill = getFill();
    setFill(BColor.orange.toBrush());
    repaint();
  }
  public void mouseExited(BMouseEvent event)
  {
    setFill(realFill);
    repaint();
  }                      
  BBrush realFill;      
  */

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/shape.png");
}



