/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.shape;

import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * BRect renders a rectangle shape.
 *
 * @author    Brian Frank
 * @creation  2 Apr 04
 * @version   $Revision: 3$ $Date: 3/28/05 10:32:30 AM EST$
 * @since     Baja 1.0
 */
public class BRect
  extends BShape
{          

  /*-
  
  class BRect
  {
    properties
    {        
      geom: BRectGeom        
        -- The geometry of the rectangle.
        default {[ BRectGeom.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BRect(3150804707)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "geom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>geom</code> property.
   * The geometry of the rectangle.
   * @see javax.baja.ui.shape.BRect#getGeom
   * @see javax.baja.ui.shape.BRect#setGeom
   */
  public static final Property geom = newProperty(0, BRectGeom.NULL,null);
  
  /**
   * Get the <code>geom</code> property.
   * The geometry of the rectangle.
   * @see javax.baja.ui.shape.BRect#geom
   */
  public BRectGeom getGeom() { return (BRectGeom)get(geom); }
  
  /**
   * Set the <code>geom</code> property.
   * The geometry of the rectangle.
   * @see javax.baja.ui.shape.BRect#geom
   */
  public void setGeom(BRectGeom v) { set(geom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     
////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Rectangle with geometry, fill, stroke, and pen.
   */
  public BRect(IRectGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    super(BRectGeom.make(geom), fill, stroke, pen);   
  } 

  /**
   * Rectangle with geometry.
   */
  public BRect(IRectGeom geom)
  {                        
    super(BRectGeom.make(geom));   
  } 

  /**
   * Rectangle constructor.
   */
  public BRect()
  {
  } 
     
////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Return the geom property.
   */
  public BGeom getShapeGeom()
  {           
    return getGeom();
  }

  /**
   * Set geom property.
   */
  public void setShapeGeom(BGeom geom)
  {
    setGeom((BRectGeom)geom);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/rect.png");
}



