/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.shape;

import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * BPolygon renders a polygon.
 *
 * @author    Brian Frank
 * @creation  2 Apr 04
 * @version   $Revision: 3$ $Date: 3/28/05 10:32:29 AM EST$
 * @since     Baja 1.0
 */
public class BPolygon
  extends BShape
{          

  /*-
  
  class BPolygon
  {
    properties
    {        
      geom: BPolygonGeom        
        -- The geometry of the polygon.
        default {[ BPolygonGeom.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BPolygon(572351791)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "geom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>geom</code> property.
   * The geometry of the polygon.
   * @see javax.baja.ui.shape.BPolygon#getGeom
   * @see javax.baja.ui.shape.BPolygon#setGeom
   */
  public static final Property geom = newProperty(0, BPolygonGeom.NULL,null);
  
  /**
   * Get the <code>geom</code> property.
   * The geometry of the polygon.
   * @see javax.baja.ui.shape.BPolygon#geom
   */
  public BPolygonGeom getGeom() { return (BPolygonGeom)get(geom); }
  
  /**
   * Set the <code>geom</code> property.
   * The geometry of the polygon.
   * @see javax.baja.ui.shape.BPolygon#geom
   */
  public void setGeom(BPolygonGeom v) { set(geom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPolygon.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     
////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Construct with geometry, fill, stroke, and pen.
   */
  public BPolygon(IPolygonGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    super(BPolygonGeom.make(geom), fill, stroke, pen);   
  } 

  /**
   * Construct with geometry.
   */
  public BPolygon(IPolygonGeom geom)
  {                        
    super(BPolygonGeom.make(geom));   
  } 

  /**
   * Default constructor.
   */
  public BPolygon()
  {
  } 
     
////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Return the geom property.
   */
  public BGeom getShapeGeom()
  {           
    return getGeom();
  }

  /**
   * Set geom property.
   */
  public void setShapeGeom(BGeom geom)
  {
    setGeom((BPolygonGeom)geom);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/polygon.png");
}



