/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.shape;

import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * BPath renders a general path.
 *
 * @author    Brian Frank
 * @creation  5 Apr 04
 * @version   $Revision: 5$ $Date: 3/28/05 10:32:29 AM EST$
 * @since     Baja 1.0
 */
public class BPath
  extends BShape
{          

  /*-
  
  class BPath
  {
    properties
    {        
      geom: BPathGeom        
        -- The geometry of the path.
        default {[ BPathGeom.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BPath(3903397057)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "geom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>geom</code> property.
   * The geometry of the path.
   * @see javax.baja.ui.shape.BPath#getGeom
   * @see javax.baja.ui.shape.BPath#setGeom
   */
  public static final Property geom = newProperty(0, BPathGeom.NULL,null);
  
  /**
   * Get the <code>geom</code> property.
   * The geometry of the path.
   * @see javax.baja.ui.shape.BPath#geom
   */
  public BPathGeom getGeom() { return (BPathGeom)get(geom); }
  
  /**
   * Set the <code>geom</code> property.
   * The geometry of the path.
   * @see javax.baja.ui.shape.BPath#geom
   */
  public void setGeom(BPathGeom v) { set(geom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPath.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     
////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Construct with geometry, fill, stroke, and pen.
   */
  public BPath(IPathGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    super(BPathGeom.make(geom), fill, stroke, pen);   
  } 

  /**
   * Construct with geometry.
   */
  public BPath(IPathGeom geom)
  {                        
    super(BPathGeom.make(geom));   
  } 

  /**
   * Default constructor.
   */
  public BPath()
  {
  } 

////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////

  /**
   * Return if the geometry contains the point.
   */        
  /*                                  
  public boolean contains(double x, double y)
  {
//System.out.println("BPath.contains: " + x + ", " + y + ", " + 
//getGeom().support(GxEnv.AWT).getClass().getName());

    // getShapeGeom().peer() is a java.awt.geom.GeneralPath, but
    // java.awt.geom.GeneralPath.contains(x, y) will not work here,
    // because of its idiosyncratic behaviour.
    //
    // Instead, we return true if the point is "near"
    // the flattened version of the path

    Point[] pnts = AwtUtil.flatten(getGeom(), GeomUtil.NEAR);
    double dist = GeomUtil.dist(new Point(x, y), pnts);

    return (dist <= GeomUtil.NEAR);
  }          
  */
  
////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Return the geom property.
   */
  public BGeom getShapeGeom()
  {           
    return getGeom();
  }

  /**
   * Set geom property.
   */
  public void setShapeGeom(BGeom geom)
  {
    setGeom((BPathGeom)geom);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/path.png");
}



