/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.shape;

import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * BEllipse renders a ellipse geometry.
 *
 * @author    Brian Frank
 * @creation  5 Apr 04
 * @version   $Revision: 3$ $Date: 3/28/05 10:32:29 AM EST$
 * @since     Baja 1.0
 */
public class BEllipse
  extends BShape
{          

  /*-
  
  class BEllipse
  {
    properties
    {        
      geom: BEllipseGeom        
        -- The geometry of the Ellipse.
        default {[ BEllipseGeom.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BEllipse(322484584)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "geom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>geom</code> property.
   * The geometry of the Ellipse.
   * @see javax.baja.ui.shape.BEllipse#getGeom
   * @see javax.baja.ui.shape.BEllipse#setGeom
   */
  public static final Property geom = newProperty(0, BEllipseGeom.NULL,null);
  
  /**
   * Get the <code>geom</code> property.
   * The geometry of the Ellipse.
   * @see javax.baja.ui.shape.BEllipse#geom
   */
  public BEllipseGeom getGeom() { return (BEllipseGeom)get(geom); }
  
  /**
   * Set the <code>geom</code> property.
   * The geometry of the Ellipse.
   * @see javax.baja.ui.shape.BEllipse#geom
   */
  public void setGeom(BEllipseGeom v) { set(geom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEllipse.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     
////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Construct with geometry, fill, stroke, and pen.
   */
  public BEllipse(IEllipseGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    super(BEllipseGeom.make(geom), fill, stroke, pen);   
  } 

  /**
   * Construct with geometry.
   */
  public BEllipse(IEllipseGeom geom)
  {                        
    super(BEllipseGeom.make(geom));   
  } 

  /**
   * Default constructor.
   */
  public BEllipse()
  {
  } 
     
////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Return the geom property.
   */
  public BGeom getShapeGeom()
  {           
    return getGeom();
  }

  /**
   * Set geom property.
   */
  public void setShapeGeom(BGeom geom)
  {
    setGeom((BEllipseGeom)geom);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/ellipse.png");

}



