/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.px;

import javax.baja.sys.*;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;

/**
 * BPxTemplateInfo is a container class for info needed to link deployed px files to source template.
 *
 * @author Robert Adams
 * @creation 8/26/2014
 * @since Baja 1.0
 */
@NiagaraType
  @NiagaraSlots( properties = {
    /** Name of template containing associated px file */
    @NiagaraProperty( name="templateName", type="String",flags = Flags.READONLY,  defaultValue="" ),
    /** Template vendor */
    @NiagaraProperty( name="vendor", type="String",flags = Flags.READONLY,  defaultValue="" ),
    /** Template version */
    @NiagaraProperty( name="version", type="String",flags = Flags.READONLY,  defaultValue="" )
  }
)
public class BPxTemplateInfo
   extends BStruct
{

/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.px.BPxTemplateInfo(649690913)1.0$ @*/
/* Generated Fri Mar 23 09:49:52 EDT 2018 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "templateName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code templateName} property.
   * Name of template containing associated px file
   * @see #getTemplateName
   * @see #setTemplateName
   */
  public static final Property templateName = newProperty(Flags.READONLY, "", null);
  
  /**
   * Get the {@code templateName} property.
   * Name of template containing associated px file
   * @see #templateName
   */
  public String getTemplateName() { return getString(templateName); }
  
  /**
   * Set the {@code templateName} property.
   * Name of template containing associated px file
   * @see #templateName
   */
  public void setTemplateName(String v) { setString(templateName, v, null); }

////////////////////////////////////////////////////////////////
// Property "vendor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code vendor} property.
   * Template vendor
   * @see #getVendor
   * @see #setVendor
   */
  public static final Property vendor = newProperty(Flags.READONLY, "", null);
  
  /**
   * Get the {@code vendor} property.
   * Template vendor
   * @see #vendor
   */
  public String getVendor() { return getString(vendor); }
  
  /**
   * Set the {@code vendor} property.
   * Template vendor
   * @see #vendor
   */
  public void setVendor(String v) { setString(vendor, v, null); }

////////////////////////////////////////////////////////////////
// Property "version"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code version} property.
   * Template version
   * @see #getVersion
   * @see #setVersion
   */
  public static final Property version = newProperty(Flags.READONLY, "", null);
  
  /**
   * Get the {@code version} property.
   * Template version
   * @see #version
   */
  public String getVersion() { return getString(version); }
  
  /**
   * Set the {@code version} property.
   * Template version
   * @see #version
   */
  public void setVersion(String v) { setString(version, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPxTemplateInfo.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /** Empty constructor */
  public BPxTemplateInfo() {}

  /** Constructor with property values. */
  public BPxTemplateInfo(String name, String vendor, String version)
  {
    setTemplateName(name);
    setVendor(vendor);
    setVersion(version);
  }
}
