/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.px;

import javax.baja.sys.*;

/**
 * A BLayerTag tags its parent BWidget
 * as belonging to a given Px Layer.
 * 
 * @author    Mike Jarmy
 * @creation  13 Jul 09
 * @version   $Revision: 2$ $Date: 6/10/10 11:05:56 AM EDT$
 * @since     Baja 1.0
 */
public class BLayerTag
  extends BStruct
{
  /*-
  
  class BLayerTag
  {
    properties
    {
      layerName: String
        -- The name of the layer.
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.px.BLayerTag(1623495001)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "layerName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>layerName</code> property.
   * The name of the layer.
   * @see javax.baja.ui.px.BLayerTag#getLayerName
   * @see javax.baja.ui.px.BLayerTag#setLayerName
   */
  public static final Property layerName = newProperty(0, "",null);
  
  /**
   * Get the <code>layerName</code> property.
   * The name of the layer.
   * @see javax.baja.ui.px.BLayerTag#layerName
   */
  public String getLayerName() { return getString(layerName); }
  
  /**
   * Set the <code>layerName</code> property.
   * The name of the layer.
   * @see javax.baja.ui.px.BLayerTag#layerName
   */
  public void setLayerName(String v) { setString(layerName,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLayerTag.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BLayerTag()
  {
  }

  public BLayerTag(String name) 
  {
    setLayerName(name);
  }
  
  public boolean isNull()
  {
    return this.equals(BLayerTag.NULL) || this.getLayerName().length()==0;
  }
  
  public static final BLayerTag NULL = new BLayerTag(BString.DEFAULT.toString());
}
