/*
 * Copyright 2000, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.ui.pane;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.*;

/**
 * BLabelPane is a pane which contains a label widget and a 
 * content widget.  BLabelPane is designed to be used inside 
 * BLabelPaneContainers which layout corresponding label and 
 * widgets.  The BLabelPane has no layout implementation 
 * itself, but relies on its parent BLabelPaneContainer to 
 * perform its layout.
 *
 * @author    Brian Frank
 * @creation  5 Dec 00
 * @version   $Revision: 19$ $Date: 3/28/05 10:32:28 AM EST$
 * @since     Baja 1.0
 */
public class BLabelPane
  extends BPane
{

  /*-
  
  class BLabelPane
  {
    properties
    {
      label: BLabel
        -- The label which describes the content.
        default {[ new BLabel("no label") ]}
      content: BWidget
        -- The widget for the content content.
        default {[ new BNullWidget() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.pane.BLabelPane(3195034616)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "label"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>label</code> property.
   * The label which describes the content.
   * @see javax.baja.ui.pane.BLabelPane#getLabel
   * @see javax.baja.ui.pane.BLabelPane#setLabel
   */
  public static final Property label = newProperty(0, new BLabel("no label"),null);
  
  /**
   * Get the <code>label</code> property.
   * The label which describes the content.
   * @see javax.baja.ui.pane.BLabelPane#label
   */
  public BLabel getLabel() { return (BLabel)get(label); }
  
  /**
   * Set the <code>label</code> property.
   * The label which describes the content.
   * @see javax.baja.ui.pane.BLabelPane#label
   */
  public void setLabel(BLabel v) { set(label,v,null); }

////////////////////////////////////////////////////////////////
// Property "content"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>content</code> property.
   * The widget for the content content.
   * @see javax.baja.ui.pane.BLabelPane#getContent
   * @see javax.baja.ui.pane.BLabelPane#setContent
   */
  public static final Property content = newProperty(0, new BNullWidget(),null);
  
  /**
   * Get the <code>content</code> property.
   * The widget for the content content.
   * @see javax.baja.ui.pane.BLabelPane#content
   */
  public BWidget getContent() { return (BWidget)get(content); }
  
  /**
   * Set the <code>content</code> property.
   * The widget for the content content.
   * @see javax.baja.ui.pane.BLabelPane#content
   */
  public void setContent(BWidget v) { set(content,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLabelPane.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with label and content widget.
   */
  public BLabelPane(BLabel label, BWidget widget)
  {
    setLabel(label);
    setContent(widget);
  }

  /**
   * Constructor with label text and content widget.
   */
  public BLabelPane(String label, BWidget widget)
  {
    getLabel().setText(label);
    setContent(widget);
  }

  /**
   * Constructor with label text and image and content widget.
   */
  public BLabelPane(String label, BImage image, BWidget widget)
  {
    getLabel().setText(label);
    if (image != null) getLabel().setImage(image);
    setContent(widget);
  }

  /**
   * No argument constructor.
   */
  public BLabelPane()
  {
  }

////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////
  
  public void doLayout(BWidget[] kids) {}

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /**
   * Only BLabelPaneContainer is a valid parent.
   */
  public boolean isParentLegal(BComponent parent)
  {
    if (!super.isParentLegal(parent)) return false;
    return (parent instanceof BLabelPaneContainer);
  }
  
////////////////////////////////////////////////////////////////
//BComponent
////////////////////////////////////////////////////////////////

  public void setEnabled(boolean enabled)
  {
    super.setEnabled(enabled);
    getLabel().setEnabled(enabled);
  }

}
