/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.naming;

import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.pane.*;

/**
 * BRootContainer contains the root widget of a 'widget space'.
 * BWidgetScheme uses BRootContainer to resolve widget queries.
 *
 * @author    Mike Jarmy
 * @creation  13 Dec 06
 * @version   $Revision: 3$ $Date: 4/20/07 9:15:30 AM EDT$
 * @since     Baja 1.0
 */
public class BRootContainer
  extends BPane
{
  /*-
  
  class BRootContainer
  {
    properties
    {
      root: BWidget
        default {[ new BNullWidget() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.naming.BRootContainer(783569820)1.0$ @*/
/* Generated Mon Mar 26 13:34:56 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "root"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>root</code> property.
   * @see javax.baja.ui.naming.BRootContainer#getRoot
   * @see javax.baja.ui.naming.BRootContainer#setRoot
   */
  public static final Property root = newProperty(0, new BNullWidget(),null);
  
  /**
   * Get the <code>root</code> property.
   * @see javax.baja.ui.naming.BRootContainer#root
   */
  public BWidget getRoot() { return (BWidget)get(root); }
  
  /**
   * Set the <code>root</code> property.
   * @see javax.baja.ui.naming.BRootContainer#root
   */
  public void setRoot(BWidget v) { set(root,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRootContainer.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Construct an empty root container.
   */
  public BRootContainer()
  {
  }

  /**
   * Construct a root container with the given root.
   */
  public BRootContainer(BWidget root)
  {
    setRoot(root);
  }

////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////

  public void computePreferredSize()
	{
		BWidget root = getRoot();

    root.computePreferredSize();
		setPreferredSize(
			root.getPreferredWidth(),
			root.getPreferredHeight());
	}

  public void doLayout(BWidget[] kids)
	{
		getRoot().setBounds(0, 0, getWidth(), getHeight());
	}
}
