/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.menu;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.ToggleCommandGroup;

/**
 * BIToggleMenuItem represents an interface for manipulating menu items within a BIMenu
 * instance that support the notion of toggling (e.g. radio buttons or checkboxes)
 * @author    Danesh Kamal
 * @creation  11/1/2013
 * @version   1
 * @since     Niagara 4.0
 */
public interface BIToggleMenuItem
    extends BIMenuItem
{

  /**
   * Return the toggle group to which this toggle item belongs
   * @return the toggle group
   */
  @SuppressWarnings("rawtypes")
  public ToggleCommandGroup getToggleGroup();

  /**
   * @return whether the menu item is selected
   */
  public boolean isSelected();

  /**
   * @return whether the menu item is a check box toggle item
   */
  public boolean isCheckBoxItem();

  /**
   * @return whether the menu item is a radio button toggle item
   */
  public boolean isRadioButtonItem();

  public static final Type TYPE = Sys.loadType(BIToggleMenuItem.class);
} 
