/*                          
 * Copyright 2000, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.ui.list;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;
import javax.baja.ui.util.*;

/**
 * BCheckList extends BList to use the selection state to check 
 * and uncheck.  BCheckList uses its own implementation of 
 * ListController and ListRenderer.
 *
 * @author    Brian Frank
 * @creation  30 Sept 02
 * @version   $Revision: 24$ $Date: 6/27/11 12:44:40 PM EDT$
 * @since     Baja 1.0
 */
public class BCheckList
  extends BList
{

  static final BImage DEFAULT_SELECTED_ICON = BImage.make("module://icons/x16/check.png");
  
  /*-
  
  class BCheckList
  {
    properties
    {      
      selectedIcon: BImage                 
        -- Icon to use when item is selected.
        default {[ DEFAULT_SELECTED_ICON ]}
      unselectedIcon: BImage                 
        -- Icon to use when item is selected.
        default {[ BImage.NULL ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.list.BCheckList(956243547)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "selectedIcon"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#getSelectedIcon
   * @see javax.baja.ui.list.BCheckList#setSelectedIcon
   */
  public static final Property selectedIcon = newProperty(0, DEFAULT_SELECTED_ICON,null);
  
  /**
   * Get the <code>selectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#selectedIcon
   */
  public BImage getSelectedIcon() { return (BImage)get(selectedIcon); }
  
  /**
   * Set the <code>selectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#selectedIcon
   */
  public void setSelectedIcon(BImage v) { set(selectedIcon,v,null); }

////////////////////////////////////////////////////////////////
// Property "unselectedIcon"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unselectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#getUnselectedIcon
   * @see javax.baja.ui.list.BCheckList#setUnselectedIcon
   */
  public static final Property unselectedIcon = newProperty(0, BImage.NULL,null);
  
  /**
   * Get the <code>unselectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#unselectedIcon
   */
  public BImage getUnselectedIcon() { return (BImage)get(unselectedIcon); }
  
  /**
   * Set the <code>unselectedIcon</code> property.
   * Icon to use when item is selected.
   * @see javax.baja.ui.list.BCheckList#unselectedIcon
   */
  public void setUnselectedIcon(BImage v) { set(unselectedIcon,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCheckList.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constuctors
////////////////////////////////////////////////////////////////

  /**
   * Construct a
   */
  public BCheckList()
  {
    setController(new CheckListController());
    setRenderer(new CheckListRenderer());
  }

////////////////////////////////////////////////////////////////
// Controller
////////////////////////////////////////////////////////////////  

  public static class CheckListController
    extends ListController
  {
    public void focusGained(BFocusEvent event)
    {
    }
    
    protected void itemPressed(BMouseEvent event, int index)
    {
      if (event.isPopupTrigger()) itemPopup(event, index);
    }
    
    protected void itemReleased(BMouseEvent event, int index)
    {
      if (event.isPopupTrigger()) itemPopup(event, index);
      else
      {
        ListSelection sel = list.getSelection();
        if (sel.isSelected(index))
          sel.deselect(index);
        else
          sel.select(index);        
      }
    }

    protected void backgroundPressed(BMouseEvent event)
    {
      if (event.isPopupTrigger()) backgroundPopup(event); 
    }                 
        
    protected BMenu makePopup(ListSubject subject)
    {                                                
      BMenu menu = new BMenu();
      menu.add(null, new SelectAllCommand(getList()));
      menu.add(null, new DeselectAllCommand(getList()));
      return menu;
    }
  }                                      
  
  public static class SelectAllCommand extends Command
  {            
    SelectAllCommand(BList list) { super(list, UiLexicon.bajaui().module, "commands.selectAll"); }
    public CommandArtifact doInvoke()
    {             
      ((BList)getOwner()).getSelection().selectAll();
      return null;
    }
  }

  public static class DeselectAllCommand extends Command
  {            
    DeselectAllCommand(BList list) { super(list, UiLexicon.bajaui().module, "commands.deselectAll"); }
    public CommandArtifact doInvoke()
    {             
      ((BList)getOwner()).getSelection().deselectAll();
      return null;
    }
  }

////////////////////////////////////////////////////////////////
// Renderer
////////////////////////////////////////////////////////////////  

  public static class CheckListRenderer
    extends ListRenderer
  {
    public BBrush getSelectionForeground(Item item)
    {
      return getForeground(item);
    }
  
    public BBrush getSelectionBackground(Item item)
    {
      return getBackground(item);
    }
  
    public double getPreferredItemWidth(Item item)
    {
      BCheckList cl = (BCheckList)getList();
      double w = super.getPreferredItemWidth(item) +
        Math.max(cl.getSelectedIcon().getWidth(), 
        cl.getUnselectedIcon().getHeight()) + cl.hgap;
      return w;
    }
  
    public void paintItem(Graphics g, Item item)
    {
      paintItemBackground(g, item);

      BCheckList list = (BCheckList)getList();
      double inset = Math.max(list.getSelectedIcon().getWidth(),
        list.getUnselectedIcon().getWidth()) + list.hgap;
      
      g.translate(inset, 0);
      super.paintItem(g, item);
      g.translate(-inset, 0);
      
      BImage icon = item.selected ? list.getSelectedIcon() : list.getUnselectedIcon();
      if (!icon.isNull())
        g.drawImage(icon, 2, 0);
    }
  }
  
////////////////////////////////////////////////////////////////
// Attributes 
////////////////////////////////////////////////////////////////
  
  private double hgap = 4;
}
