/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.ui.event;

import javax.baja.sys.*;
import javax.baja.ui.*;

/**
 * BSliderEvent indicates a change in slider positioning.
 *
 * @author    Andy Frank
 * @creation  16 May 01
 * @version   $Revision: 5$ $Date: 3/3/09 10:19:17 AM EST$
 * @since     Baja 1.0
 */
public class BSliderEvent
  extends BWidgetEvent
{


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final int VALUE_CHANGED = 602; //AdjustmentEvent.ADJUSTMENT_VALUE_CHANGED+1;

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSliderEvent.class);

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Construct a new focus event.
   */
  public BSliderEvent(int id, BWidget source, double value)
  {
    super(id, source);
    this.value = value;
  }

  /**
   * No arg constructor
   */
  public BSliderEvent()
  {
  }

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Get the new slider value.
   */
  public double getValue()
  {
    return value;
  }

  public String toString(Context context)
  {
    return "BSliderEvent[VALUE_CHANGED val" + value + "]";
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private double value;
}
