/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BScrollBarPolicy determines when a BScrollPane displays
 * its horizontal or vertical scroll bars.
 *
 * @author    Brian Frank
 * @creation  26 Nov 00
 * @version   $Revision: 2$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
public final class BScrollBarPolicy
  extends BFrozenEnum
{
  /*-
  
  enum BScrollBarPolicy
  {
    range
    {
      asNeeded,
      always,
      never
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BScrollBarPolicy(849711898)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for asNeeded. */
  public static final int AS_NEEDED = 0;
  /** Ordinal value for always. */
  public static final int ALWAYS = 1;
  /** Ordinal value for never. */
  public static final int NEVER = 2;
  
  /** BScrollBarPolicy constant for asNeeded. */
  public static final BScrollBarPolicy asNeeded = new BScrollBarPolicy(AS_NEEDED);
  /** BScrollBarPolicy constant for always. */
  public static final BScrollBarPolicy always = new BScrollBarPolicy(ALWAYS);
  /** BScrollBarPolicy constant for never. */
  public static final BScrollBarPolicy never = new BScrollBarPolicy(NEVER);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BScrollBarPolicy.class);
  
  /** Factory method with ordinal. */
  public static BScrollBarPolicy make(int ordinal)
  {
    return (BScrollBarPolicy)asNeeded.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BScrollBarPolicy make(String tag)
  {
    return (BScrollBarPolicy)asNeeded.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BScrollBarPolicy(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BScrollBarPolicy DEFAULT = BScrollBarPolicy.asNeeded;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}

