/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BButtonStyle defines an enumeration for how buttons
 * should look and behave.
 *
 * @author    Andy Frank
 * @creation  21 Nov 02
 * @version   $Revision: 3$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
public final class BButtonStyle
  extends BFrozenEnum
{

  /*-
  
  enum BButtonStyle
  {
    range
    {
      none,
      normal,
      toolBar,
      hyperlink
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BButtonStyle(3246104896)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for none. */
  public static final int NONE = 0;
  /** Ordinal value for normal. */
  public static final int NORMAL = 1;
  /** Ordinal value for toolBar. */
  public static final int TOOL_BAR = 2;
  /** Ordinal value for hyperlink. */
  public static final int HYPERLINK = 3;
  
  /** BButtonStyle constant for none. */
  public static final BButtonStyle none = new BButtonStyle(NONE);
  /** BButtonStyle constant for normal. */
  public static final BButtonStyle normal = new BButtonStyle(NORMAL);
  /** BButtonStyle constant for toolBar. */
  public static final BButtonStyle toolBar = new BButtonStyle(TOOL_BAR);
  /** BButtonStyle constant for hyperlink. */
  public static final BButtonStyle hyperlink = new BButtonStyle(HYPERLINK);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BButtonStyle.class);
  
  /** Factory method with ordinal. */
  public static BButtonStyle make(int ordinal)
  {
    return (BButtonStyle)none.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BButtonStyle make(String tag)
  {
    return (BButtonStyle)none.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BButtonStyle(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BButtonStyle DEFAULT = BButtonStyle.none;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}

