/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.bookmark;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * BBookmarkItem.
 *
 * @author    Andy Frank
 * @creation  11 Feb 03
 * @version   $Revision: 4$ $Date: 2/17/04 2:58:18 PM EST$
 * @since     Baja 1.0
 */
public class BBookmarkItem
  extends BComponent
{ 
  /*-
  class BBookmarkItem
  {
    properties
    {
      text: String
        -- The human readable name for this bookmark.
        default {[ "BookmarkItem" ]}
      
      iconOrd: BOrdList
        -- The ord to the icon to use for this bookmark.
        default {[ BIcon.std("bookmark.png").getOrdList() ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.bookmark.BBookmarkItem(74069838)1.0$ @*/
/* Generated Sat Dec 17 22:53:01 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "text"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>text</code> property.
   * The human readable name for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#getText
   * @see javax.baja.ui.bookmark.BBookmarkItem#setText
   */
  public static final Property text = newProperty(0, "BookmarkItem",null);
  
  /**
   * Get the <code>text</code> property.
   * The human readable name for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#text
   */
  public String getText() { return getString(text); }
  
  /**
   * Set the <code>text</code> property.
   * The human readable name for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#text
   */
  public void setText(String v) { setString(text,v,null); }

////////////////////////////////////////////////////////////////
// Property "iconOrd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>iconOrd</code> property.
   * The ord to the icon to use for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#getIconOrd
   * @see javax.baja.ui.bookmark.BBookmarkItem#setIconOrd
   */
  public static final Property iconOrd = newProperty(0, BIcon.std("bookmark.png").getOrdList(),null);
  
  /**
   * Get the <code>iconOrd</code> property.
   * The ord to the icon to use for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#iconOrd
   */
  public BOrdList getIconOrd() { return (BOrdList)get(iconOrd); }
  
  /**
   * Set the <code>iconOrd</code> property.
   * The ord to the icon to use for this bookmark.
   * @see javax.baja.ui.bookmark.BBookmarkItem#iconOrd
   */
  public void setIconOrd(BOrdList v) { set(iconOrd,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBookmarkItem.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Get icon.
   */
  public BIcon getIcon()
  {
    if (icon == null) icon = BIcon.make(getIconOrd());
    return icon;
  }
  private BIcon icon = null;

  /**
   * Convience for <code>setIconOrd(icon.getOrdList())</code>.
   */
  public void setIcon(BIcon icon)
  {
    setIconOrd(icon.getOrdList());
  }
}
