/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.menu.BIToggleMenuItem;

/**
 * BToggleMenuItem is the base class for BCheckBoxMenuItem
 * and BRadioButtonMenuItem.
 *
 * @author    Brian Frank       
 * @creation  5 Jan 01
 * @version   $Revision: 14$ $Date: 5/9/05 3:40:26 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BToggleMenuItem
  extends BActionMenuItem implements BIToggleMenuItem
{ 

  /*-    
  
  class BToggleMenuItem
  {
  
    properties
    {
      selected: boolean
        -- The selected property indicates whether the 
        -- checkbox is currently selected or unselected.
        default {[ false ]}
    }
    
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BToggleMenuItem(2722649008)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "selected"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selected</code> property.
   * The selected property indicates whether the checkbox
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleMenuItem#getSelected
   * @see javax.baja.ui.BToggleMenuItem#setSelected
   */
  public static final Property selected = newProperty(0, false,null);
  
  /**
   * Get the <code>selected</code> property.
   * The selected property indicates whether the checkbox
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleMenuItem#selected
   */
  public boolean getSelected() { return getBoolean(selected); }
  
  /**
   * Set the <code>selected</code> property.
   * The selected property indicates whether the checkbox
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleMenuItem#selected
   */
  public void setSelected(boolean v) { setBoolean(selected,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BToggleMenuItem.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Construct a menu item with specified label 
   * text, accelerator, and initial selection state.
   */
  public BToggleMenuItem(String text, BAccelerator accelerator, boolean selected)
  {
    super(text, accelerator);
    setSelected(selected);
  }

  /**
   * Construct a menu item with specified label text and selected state.
   */
  public BToggleMenuItem(String text, boolean selected)
  {
    super(text);
    setSelected(selected);
  }  

  /**
   * Construct a menu item with specified label text.
   */
  public BToggleMenuItem(String text)
  {
    super(text);
  }

  /**
   * Construct a menu item for the specified command
   * using the command's label, accelerator, and icon.
   */
  public BToggleMenuItem(ToggleCommand command)
  {
    super(command);
  }

  /**
   * No argument constructor.
   */
  public BToggleMenuItem()
  {
  }

////////////////////////////////////////////////////////////////
// BIMenuItem
////////////////////////////////////////////////////////////////

  @Override
  public boolean isSelected()
  {
    return getSelected();
  }

  @Override
  public boolean isCheckBoxItem()
  {
    return false;
  }

  @Override
  public boolean isRadioButtonItem()
  {
    return false;
  }

  @Override
  @SuppressWarnings("rawtypes")
  public ToggleCommandGroup getToggleGroup()
  {
    return ((ToggleCommand)getCommand()).getGroup();
  }

  ////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  public void doInvokeAction(CommandEvent event)
  {
    setSelected( !getSelected() );    
    super.doInvokeAction(event);
  }

  public void setCommand(Command command, boolean useLabel, boolean useIcon, boolean useAcc)
  {
    if (command != null)
    {
      if (!(command instanceof ToggleCommand))
        throw new IllegalArgumentException("Not ToggleCommand!");
      setSelected( ((ToggleCommand)command).isSelected() );
    }
    super.setCommand(command, useLabel, useIcon, useAcc);
  }

  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == selected)
    {
      if (command != null)
        ((ToggleCommand)command).setSelected(getSelected());
    }
  }

}
