  /*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

  import java.text.NumberFormat;
  import javax.baja.gx.BBrush;
  import javax.baja.gx.Graphics;
  import javax.baja.gx.RectGeom;
  import javax.baja.sys.BIcon;
  import javax.baja.sys.Property;
  import javax.baja.sys.Sys;
  import javax.baja.sys.Topic;
  import javax.baja.sys.Type;
  import javax.baja.ui.enums.BOrientation;
  import javax.baja.ui.event.BMouseEvent;
  import javax.baja.ui.event.BSliderEvent;
  import com.tridium.ui.UiEnv;
  import com.tridium.ui.theme.SliderTheme;
  import com.tridium.ui.theme.Theme;

/**
 * BSlider provides a visual slider which is used to
 * select and integer or doubleing point value between
 * a fixed range.
 *
 * @author    Andy Frank
 * @creation  16 May 01
 * @version   $Revision: 30$ $Date: 5/12/05 3:59:58 PM EDT$
 * @since     Baja 1.0
 */
public class BSlider
  extends BWidget
{

/*-

  class BSlider
  {
    properties
    {
      min: double
        -- The minumim value the slider can move to.
        default {[ 0 ]}

      max: double
        -- The max value the slider can move to.
        default {[ 100 ]}

      increment: double
        -- The smallest possible value that the slider
        -- can increment by.
        default {[ 1 ]}

      value: double
        -- The currently selected value on the slider bar.
        default {[ 50 ]}

      orientation: BOrientation
        -- The orientation of the slider bar.
        default {[ BOrientation.horizontal ]}
        
      trackBrush: BBrush
        -- The color to paint the track or null to use default.
        default {[ BBrush.NULL ]}
        
      thumbBrush: BBrush
        -- The color to paint the thumb or null to use default.
        default {[ BBrush.NULL ]}
    }

    topics
    {
      valueModified: BSliderEvent
        -- Event fired when the position is modified.
      actionPerformed: BSliderEvent  
        -- Event fired when the mouse is released after dragging slider.        
    }
  }

-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BSlider(3471793392)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * The minumim value the slider can move to.
   * @see javax.baja.ui.BSlider#getMin
   * @see javax.baja.ui.BSlider#setMin
   */
  public static final Property min = newProperty(0, 0,null);
  
  /**
   * Get the <code>min</code> property.
   * The minumim value the slider can move to.
   * @see javax.baja.ui.BSlider#min
   */
  public double getMin() { return getDouble(min); }
  
  /**
   * Set the <code>min</code> property.
   * The minumim value the slider can move to.
   * @see javax.baja.ui.BSlider#min
   */
  public void setMin(double v) { setDouble(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * The max value the slider can move to.
   * @see javax.baja.ui.BSlider#getMax
   * @see javax.baja.ui.BSlider#setMax
   */
  public static final Property max = newProperty(0, 100,null);
  
  /**
   * Get the <code>max</code> property.
   * The max value the slider can move to.
   * @see javax.baja.ui.BSlider#max
   */
  public double getMax() { return getDouble(max); }
  
  /**
   * Set the <code>max</code> property.
   * The max value the slider can move to.
   * @see javax.baja.ui.BSlider#max
   */
  public void setMax(double v) { setDouble(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "increment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>increment</code> property.
   * The smallest possible value that the slider can increment
   * by.
   * @see javax.baja.ui.BSlider#getIncrement
   * @see javax.baja.ui.BSlider#setIncrement
   */
  public static final Property increment = newProperty(0, 1,null);
  
  /**
   * Get the <code>increment</code> property.
   * The smallest possible value that the slider can increment
   * by.
   * @see javax.baja.ui.BSlider#increment
   */
  public double getIncrement() { return getDouble(increment); }
  
  /**
   * Set the <code>increment</code> property.
   * The smallest possible value that the slider can increment
   * by.
   * @see javax.baja.ui.BSlider#increment
   */
  public void setIncrement(double v) { setDouble(increment,v,null); }

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The currently selected value on the slider bar.
   * @see javax.baja.ui.BSlider#getValue
   * @see javax.baja.ui.BSlider#setValue
   */
  public static final Property value = newProperty(0, 50,null);
  
  /**
   * Get the <code>value</code> property.
   * The currently selected value on the slider bar.
   * @see javax.baja.ui.BSlider#value
   */
  public double getValue() { return getDouble(value); }
  
  /**
   * Set the <code>value</code> property.
   * The currently selected value on the slider bar.
   * @see javax.baja.ui.BSlider#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Property "orientation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>orientation</code> property.
   * The orientation of the slider bar.
   * @see javax.baja.ui.BSlider#getOrientation
   * @see javax.baja.ui.BSlider#setOrientation
   */
  public static final Property orientation = newProperty(0, BOrientation.horizontal,null);
  
  /**
   * Get the <code>orientation</code> property.
   * The orientation of the slider bar.
   * @see javax.baja.ui.BSlider#orientation
   */
  public BOrientation getOrientation() { return (BOrientation)get(orientation); }
  
  /**
   * Set the <code>orientation</code> property.
   * The orientation of the slider bar.
   * @see javax.baja.ui.BSlider#orientation
   */
  public void setOrientation(BOrientation v) { set(orientation,v,null); }

////////////////////////////////////////////////////////////////
// Property "trackBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>trackBrush</code> property.
   * The color to paint the track or null to use default.
   * @see javax.baja.ui.BSlider#getTrackBrush
   * @see javax.baja.ui.BSlider#setTrackBrush
   */
  public static final Property trackBrush = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>trackBrush</code> property.
   * The color to paint the track or null to use default.
   * @see javax.baja.ui.BSlider#trackBrush
   */
  public BBrush getTrackBrush() { return (BBrush)get(trackBrush); }
  
  /**
   * Set the <code>trackBrush</code> property.
   * The color to paint the track or null to use default.
   * @see javax.baja.ui.BSlider#trackBrush
   */
  public void setTrackBrush(BBrush v) { set(trackBrush,v,null); }

////////////////////////////////////////////////////////////////
// Property "thumbBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thumbBrush</code> property.
   * The color to paint the thumb or null to use default.
   * @see javax.baja.ui.BSlider#getThumbBrush
   * @see javax.baja.ui.BSlider#setThumbBrush
   */
  public static final Property thumbBrush = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>thumbBrush</code> property.
   * The color to paint the thumb or null to use default.
   * @see javax.baja.ui.BSlider#thumbBrush
   */
  public BBrush getThumbBrush() { return (BBrush)get(thumbBrush); }
  
  /**
   * Set the <code>thumbBrush</code> property.
   * The color to paint the thumb or null to use default.
   * @see javax.baja.ui.BSlider#thumbBrush
   */
  public void setThumbBrush(BBrush v) { set(thumbBrush,v,null); }

////////////////////////////////////////////////////////////////
// Topic "valueModified"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueModified</code> topic.
   * Event fired when the position is modified.
   * @see javax.baja.ui.BSlider#fireValueModified
   */
  public static final Topic valueModified = newTopic(0,null);
  
  /**
   * Fire an event for the <code>valueModified</code> topic.
   * Event fired when the position is modified.
   * @see javax.baja.ui.BSlider#valueModified
   */
  public void fireValueModified(BSliderEvent event) { fire(valueModified, event, null); }

////////////////////////////////////////////////////////////////
// Topic "actionPerformed"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>actionPerformed</code> topic.
   * Event fired when the mouse is released after dragging
   * slider.
   * @see javax.baja.ui.BSlider#fireActionPerformed
   */
  public static final Topic actionPerformed = newTopic(0,null);
  
  /**
   * Fire an event for the <code>actionPerformed</code> topic.
   * Event fired when the mouse is released after dragging
   * slider.
   * @see javax.baja.ui.BSlider#actionPerformed
   */
  public void fireActionPerformed(BSliderEvent event) { fire(actionPerformed, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSlider.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * No argument constructor.
   */
  public BSlider()
  {
  }

  /**
   * Sets the min, max values.
   */
  public BSlider(double min, double max)
  {
    setMin(min);
    setMax(max);

    if (getValue() < min || getValue() > max) setValue((max + min) / 2);
  }

  /**
   * Sets the min, max, increment, and initial values.
   */
  public BSlider(double min, double max, double inc, double val)
  {
    setMin(min);
    setMax(max);
    setIncrement(inc);
    setValue(val);

    if (getValue() < min || getValue() > max) setValue((max + min) / 2);
  }

  /**
   * Sets the min, max, increment, initial and
   * orienation values.
   */
  public BSlider(BOrientation orient, double min, double max, double inc, double val)
  {
    setOrientation(orient);
    setMin(min);
    setMax(max);
    setIncrement(inc);
    setValue(val);

    if (getValue() < min || getValue() > max) setValue((max + min) / 2);
  }


////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////

  /**
   * Compute preferred size.
   */
  public void computePreferredSize()
  {
    double size = Theme.slider().getFixedWidth(this);

    if (isHorizontal())
      setPreferredSize(100, size);
    else
      setPreferredSize(size, 100);
  }

  /**
   * Layout component.
   */
  public void doLayout(BWidget[] kids)
  {
    if (isHorizontal())
      layoutHorizontally();
    else
      layoutVertically();

  }

  /**
   * Layout the component horizontally.
   */
  public void layoutHorizontally()
  {
    thumb.set(0, 0, Theme.slider().getThumbWidth(this), getHeight()-1);
    track.set(thumb.width / 2, 4, getWidth() - thumb.width, 6);

    thumbPoint = (int)(thumb.width / 2.0 + 0.5);
    viewSize = getWidth() - thumb.width;
    realSize = getMax() - getMin();
  }

  /**
   * Layout the component vertically.
   */
  public void layoutVertically()
  {
    thumb.set(0, 0, getWidth()-1, Theme.slider().getThumbWidth(this));
    track.set(4, thumb.height / 2, 6, getHeight() - thumb.height);

    thumbPoint = (int)(thumb.height / 2.0 + 0.5);
    viewSize = getHeight() - thumb.height;
    realSize = getMax() - getMin();
  }

  public boolean isHorizontal() { return getOrientation() == BOrientation.horizontal; }

////////////////////////////////////////////////////////////////
// Paint
////////////////////////////////////////////////////////////////

  /**
   * Paint the slider component.
   */
  public void paint(Graphics g)
  {
    double v = getValue();
    if (v < getMin()) v = getMin();
    if (v > getMax()) v = getMax();
    
    // Relocate the thumb if necessary
    int pos = (int)((v - getMin()) / realSize * viewSize);
    if (!isHorizontal()) pos = (int)(viewSize - pos);
    
    if (isHorizontal())
      thumb.set(pos,0,thumb.width,thumb.height);
    else
      thumb.set(0,pos,thumb.width,thumb.height);

    SliderTheme theme = Theme.slider();
    theme.paintTrack(g, this, track);
    theme.paintThumb(g, this, thumb);
  }

////////////////////////////////////////////////////////////////
// Events
////////////////////////////////////////////////////////////////

  /**
   * If the mouse is pressed on the thumb, the thumb becomes
   * "hot" and needs to be moved as the mouse is moved. If the
   * mouse was pressed on the track, then the thumb needs to
   * "paged" in the direction.
   */
  public void mousePressed(BMouseEvent event)
  {
    double v = getValue();
    if (v < getMin()) v = getMin();
    if (v > getMax()) v = getMax();
    
    String s = valueToString(v);    
    UiEnv.get().openBubbleHelp(this, event.getX(), event.getY()+24, s);
  }

  public void mouseReleased(BMouseEvent event)
  {
    UiEnv.get().closeBubbleHelp();
    fireActionPerformed(new BSliderEvent(BSliderEvent.VALUE_CHANGED, this, getValue()));
  }

  public void mouseDragged(BMouseEvent event)
  {
    double viewPos = (isHorizontal()) ? event.getX() - thumbPoint : (getHeight() - event.getY()) - thumbPoint;
    if (viewPos < 0) viewPos = 0;
    if (viewPos > viewSize) viewPos = viewSize;
    
    double newValue = (viewPos / viewSize) * realSize + getMin();

    // Do snap-to
    double inc = getIncrement();
    double temp = newValue % inc;

    if (temp > (inc / 2))
      newValue = newValue - temp + inc;
    else
      newValue = newValue - temp;

    setValue(newValue);
    fireValueModified(new BSliderEvent(BSliderEvent.VALUE_CHANGED, this, getValue()));
    repaint();
    
    // Update bubble help
    String s = valueToString(newValue);    
    UiEnv.get().updateBubbleHelp(this, event.getX(), event.getY()+24, s);
  }
  
  private String valueToString(double v)
  {
    NumberFormat format = NumberFormat.getInstance();
    format.setMaximumFractionDigits(3);
    return format.format(v);    
  }
  
///////////////////////////////////////////////////////////
// Overrides
/////////////////////////////////////////////////////////// 

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/slider.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  protected double thumbPoint;
  protected double viewSize;
  protected double realSize;

  protected RectGeom thumb = new RectGeom();
  protected RectGeom track = new RectGeom();
}
