/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import com.tridium.ui.FramePeer;
import com.tridium.ui.UiEnv;
import javax.baja.sys.Type;
import javax.baja.sys.Sys;

/**
 * 
 *
 * @author 		J. Spangler
 * @creation 	Apr 27, 2011
 * @version		1
 * @since			Niagara 3.7
 *
 */
public class BRoundedFrame
    extends BRoundedWindow
{
  /*-
   class BRoundedFrame
   {
     properties
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BRoundedFrame(3777956574)1.0$ @*/
/* Generated Wed Apr 27 16:18:59 EDT 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRoundedFrame.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructors
////////////////////////////////////////////////////////////////
  
  public BRoundedFrame(BWidget content,String title, float arcWidth, float arcHeight)
  {
    super(UiEnv.get().makeRoundedFramePeer(title, arcWidth, arcHeight));
    setContent(content);
  }
  
  public BRoundedFrame(BWidget content,float arcWidth, float arcHeight)
  {
    super(UiEnv.get().makeRoundedFramePeer("", arcWidth, arcHeight));
    setContent(content);
  }
  
  public BRoundedFrame(BWidget content)
  {
    super(UiEnv.get().makeRoundedFramePeer("", DEFAULT_ARC_WIDTH, DEFAULT_ARC_HEIGHT));
    setContent(content);
  }
  
  public BRoundedFrame(BWidget content,String title)
  {
    super(UiEnv.get().makeRoundedFramePeer(title, DEFAULT_ARC_WIDTH, DEFAULT_ARC_HEIGHT));
    setContent(content);
  }
  
  public BRoundedFrame()
  {
    super(UiEnv.get().makeRoundedFramePeer("", DEFAULT_ARC_WIDTH, DEFAULT_ARC_HEIGHT)); 
  }
  
////////////////////////////////////////////////////////////////
//  Frame
////////////////////////////////////////////////////////////////  
  
  /**
   * Get the frame title.
   */
  public String getTitle()
  {
    return ((FramePeer) getShellPeer()).getTitle();
  }

  /**
   * Set the frame title.
   */
  public void setTitle(String title)
  {
    ((FramePeer) getShellPeer()).setTitle(title);
    //TODO: set our title widget label with title text
  }
}
