/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * BIHyperlinkShell is implemented by BWidgetShell's 
 * which support the notion of hyperlinking. 
 *
 * @author    Brian Frank
 * @creation  19 May 04
 * @version   $Revision: 1$ $Date: 5/19/04 4:20:40 PM EDT$
 * @since     Baja 1.0
 */
public interface BIHyperlinkShell
  extends BInterface
{

  /**
   * Convenience for <code>hyperlink(new HyperlinkInfo(ord))</code>
   * which does a replace hyperlink to the specified ord.
   */
  public void hyperlink(BOrd ord);

  /**
   * Perform a hyperlink on this shell using the information
   * contained by the specified HyperlinkInfo including its
   * ord and mode.
   */
  public void hyperlink(HyperlinkInfo info);

  public static final Type TYPE = Sys.loadType(BIHyperlinkShell.class);
  
}