/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.gx.*;
import com.tridium.ui.*;

/**
 * BFrame is a framed window for the native desktop.
 *
 * @author    Brian Frank       
 * @creation  8 Dec 00
 * @version   $Revision: 23$ $Date: 11/13/08 4:33:50 PM EST$
 * @since     Baja 1.0
 */
public class BFrame
  extends BWindow
{ 

  /*-    
  
  class BFrame
  {
    properties
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BFrame(4175794518)1.0$ @*/
/* Generated Thu Jan 11 17:00:09 EST 2001 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFrame.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with title and content.
   */
  public BFrame(String title, BWidget content)
  {
    super(UiEnv.get().makeFramePeer(title));
    setContent(content);
  }

  /**
   * Constructor with title.
   */
  public BFrame(String title)
  {
    super(UiEnv.get().makeFramePeer(title));
  }

  /**
   * No argument constructor.
   */
  public BFrame()
  {
    super(UiEnv.get().makeFramePeer(""));
  }

////////////////////////////////////////////////////////////////
// Frame
////////////////////////////////////////////////////////////////

  /**
   * Get the frame title.
   */
  public String getTitle()
  {
    return ((FramePeer)getShellPeer()).getTitle();
  }

  /**
   * Set the frame title.
   */
  public void setTitle(String title)
  {
    ((FramePeer)getShellPeer()).setTitle(title);
  }

  /**
   * Gets the icon image for this frame.
   */
  public BImage getIconImage()
  {
    return ((FramePeer)getShellPeer()).getIconGxImage();
  }
  
  /**
   * Sets the image to displayed in the minimized icon 
   * for this frame. 
   */
  public void setIconImage(BImage iconImage)
  {
    ((FramePeer)getShellPeer()).setIconGxImage(iconImage);
  }

  public void setUndecorated(boolean undecorated)
  {  
    ((FramePeer)getShellPeer()).setUndecorated(undecorated);
  }  
    
////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////    

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/frame.png");
  
}
