/*
 * Copyright 2012 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bajascript;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;

import javax.baja.box.BIBoxTypeExt;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.js.JsInfo;


/**
 * A BajaScript Type Extension is used to extend BajaScript's own Type system.
 *
 * @author    gjohnson on 27 Jan 2011
 * @version   1
 * @since     Niagara 4.0
 */
public interface BIBajaScriptTypeExt
    extends BIBoxTypeExt
{
  Type TYPE = Sys.loadType(BIBajaScriptTypeExt.class);
  
  /**
   * Return the JavaScript information associated with this Type Extension.
   * 
   * @param cx the security context used when requesting the type extension's
   * JavaScript
   * @return info on the type extension's JavaScript implementation, or null
   * if no type extension should be loaded
   */
  JsInfo getTypeExtJs(Context cx);

  /**
   * <p>Encode and return this BajaScript Type extension to JSON. The generated
   * JSON will/must adhere to the following schema:</p>
   *
   * <pre>
   * {
   *   "title": "BIBajaScriptTypeExt JSON encoding",
   *   "type": "object",
   *   "properties": {
   *     "js": {
   *       "type": "string",
   *       "description": "RequireJS ID of the type extension implementation"
   *     },
   *     "bjs": {
   *       "type": "array",
   *       "items": { "type": "string" },
   *       "description": "Array of RequireJS IDs of built/minified files that should be loaded before requiring the primary module ID"
   *     }
   *   }
   * }
   * </pre>
   *
   * @since Niagara 4.2
   * @param cx the security context used when requesting the type extension's
   * JavaScript
   * @return JSON information about the type extension
   */
  @Override
  default JSONObject encodeToJson(Context cx)
  {
    JsInfo typeExtJs = getTypeExtJs(cx);
    JSONObject obj = new JSONObject();

    obj.put("js", typeExtJs.getJsId());
    obj.put("bjs", new JSONArray(typeExtJs.getBuiltJsIds()));

    return obj;
  }
}
