/*
 * Copyright 2012 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bajascript;

import javax.baja.box.BBoxClientEnv;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.json.JSONObject;

import com.tridium.box.env.BBajaScriptClientEnv;

/**
 * <p>A BajaScript Type Extension is used to extend BajaScript's own Type
 * system.</p>
 *
 * <p>BajaScript has its own lazy loading Type system that associates Niagara
 * Types with JavaScript constructor functions. By extending this class and
 * implementing the {@link #getTypeExtJs(Context)} method, a user can inject
 * their own JavaScript constructors into BajaScript's Type system.</p>
 * 
 * @author    gjohnson on 27 Jan 2011
 * @version   1
 * @since     Niagara 4.0
 */
public abstract class BBajaScriptTypeExt
    extends BSingleton
    implements BIBajaScriptTypeExt
{
  protected BBajaScriptTypeExt() {}
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBajaScriptTypeExt.class);
  
////////////////////////////////////////////////////////////////
// Box Type Extension
////////////////////////////////////////////////////////////////

  @Override
  public final BBoxClientEnv getClientEnv()
  {
    return BBajaScriptClientEnv.INSTANCE;
  }
    
////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

  /**
   * @deprecated
   * @see BIBajaScriptTypeExt#encodeToJson(Context)
   */
  @Deprecated
  public static JSONObject encodeToJson(BIBajaScriptTypeExt typeExt, Context cx)
  {
    return typeExt.encodeToJson(cx);
  }
}
