/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.virtual;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * BVirtualScheme provides management of the registered "virtual" ord scheme ID.
 * It resolves Ords using the "virtual" ord scheme.
 *
 * The "/" is a reserved character indicating to the virtual ord to find a child
 * slot under the resolved virtual component.
 *
 * @author    Scott Hoye
 * @creation  10 Jul 06
 * @version   $Revision: 5$ $Date: 6/11/07 12:41:24 PM EDT$
 * @since     Niagara 3.2
 */
public final class BVirtualScheme
  extends BSlotScheme
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Constructor.  Registers with the "virtual" id.
   */
  private BVirtualScheme()
  {
    super("virtual");
  }
  

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * This method is overridden to return a VirtualQuery instance.  
   */
  @Override
  public OrdQuery parse(String queryBody)
  {
    return new VirtualPath(getId(), queryBody);
  }


////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  public static final BVirtualScheme INSTANCE = new BVirtualScheme();
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BVirtualScheme.class);

}
