/**
 * Copyright 2009 Tridium, Inc. - All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;

/**
 * Validates that a BString value can be parsed as a Version.
 *
 * @author   Matthew Giannini
 * @creation  Mar 3, 2009
 * @version  $Revision: 3$ $Date: 9/24/09 8:57:55 AM EDT$
 * @since     Niagara 3.5
 *
 */
public final class BVersionValidator extends BObject
  implements BIValidator
{
  /*-
   class BVersionValidator
   {                         
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BVersionValidator(3478656207)1.0$ @*/
/* Generated Tue Sep 22 15:58:47 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BVersionValidator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Validates that a BString value can be parsed as a Version.
   * 
   * @see Version
   */
  @Override
  public void validate(BObject value, Context cx) throws CannotValidateException
  {
    String test = null;
    try
    {
      Version v = new Version(test = ((BString)value).getString());
    }
    catch (Exception e)
    {
      throw new CannotValidateException(lex.getText("versionValidator.invalid", new Object[]{test}));
    }
  }
  
  private static final Lexicon lex = Lexicon.make(BVersionValidator.class);
}
