/* 
 * Copyright 2001 Tridium, Inc.  All rights reserved.
 */

package javax.baja.util;

import javax.baja.sys.*;

/**
 * A time range within any given day, with inclusive endpoints.
 * @author Aaron Hansen
 * @creation April 2001
 * @version $Revision: 9$ $Date: 8/17/05 9:46:04 AM EDT$
 */
public class BTimeRange 
  extends BStruct
{
  
  /*-
  
  class BTimeRange
  {
    properties
    {
      startTime : BTime
        -- Inclusive
        default {[BTime.make(0,0,0,0)]}
      endTime : BTime
        -- Inclusive
        default {[BTime.make(0,0,0,0)]}
    }

    actions
    {
    }
    
    topics
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BTimeRange(1689141206)1.0$ @*/
/* Generated Sat Dec 17 22:42:37 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "startTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>startTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#getStartTime
   * @see javax.baja.util.BTimeRange#setStartTime
   */
  public static final Property startTime = newProperty(0, BTime.make(0,0,0,0),null);
  
  /**
   * Get the <code>startTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#startTime
   */
  public BTime getStartTime() { return (BTime)get(startTime); }
  
  /**
   * Set the <code>startTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#startTime
   */
  public void setStartTime(BTime v) { set(startTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "endTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>endTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#getEndTime
   * @see javax.baja.util.BTimeRange#setEndTime
   */
  public static final Property endTime = newProperty(0, BTime.make(0,0,0,0),null);
  
  /**
   * Get the <code>endTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#endTime
   */
  public BTime getEndTime() { return (BTime)get(endTime); }
  
  /**
   * Set the <code>endTime</code> property.
   * Inclusive
   * @see javax.baja.util.BTimeRange#endTime
   */
  public void setEndTime(BTime v) { set(endTime,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTimeRange.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BTimeRange() {}

  public BTimeRange(BTime start, BTime end) 
  {
    setStartTime(start);
    setEndTime(end);
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /**
   * Tests whether or not the specified time is within this range.
   * The range is inclusive of the endpoints.
   */
  public boolean includes(BAbsTime time)
  {
    return test(time.getTimeOfDayMillis());
  }

  /**
   * Tests whether or not the specified time is within this range.
   * The range is inclusive of the endpoints.
   */
  public boolean includes(BTime time)
  {
    return test(time.getTimeOfDayMillis());
  }

  /**
   * Does this time range include the entire day?
   */
  public boolean isAllDay()
  {
    return getStartTime().equals(getEndTime());
  }

  /**
   * Get a string representation of the time range.
   */  
  @Override
  public String toString(Context ctx)
  {
    return getStartTime().toString(ctx) + " - " + getEndTime().toString(ctx);
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  private boolean test(long time)
  {
    long start = getStartTime().getTimeOfDayMillis();
    long end = getEndTime().getTimeOfDayMillis();
    if (end == 0)
      end = BRelTime.MILLIS_IN_DAY;
    if (start < end)
      return (time >= start) && (time <= end);
    else //start >= end
      return (time >= start) || (time <= end);
  }


}//BTimeRange
