/*
 * Copyright 2001, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.util;

import javax.baja.sys.*;

/**
 * BStreetAddress contains the information for a site location
 * by mailing address.
 *
 * @author    John Sublett
 * @creation  18 Jan 2001
 * @version   $Revision: 3$ $Date: 1/22/01 4:31:22 PM EST$
 * @since     Baja 1.0
 */
public class BStreetAddress
  extends BStruct
{
  /*-
  
  class BStreetAddress
  {
    properties
    {
      address1: String
        -- Line 1 in the street address.
        default {[ "" ]}
        
      address2: String
        -- Line 2 in the street address, in case one line isn't enough.
        default {[ "" ]}
        
      city: String
        default {[ "" ]}
        
      state: String
        default {[ "" ]}

      zip: String
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BStreetAddress(1555184686)1.0$ @*/
/* Generated Sat Dec 17 22:42:37 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "address1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address1</code> property.
   * Line 1 in the street address.
   * @see javax.baja.util.BStreetAddress#getAddress1
   * @see javax.baja.util.BStreetAddress#setAddress1
   */
  public static final Property address1 = newProperty(0, "",null);
  
  /**
   * Get the <code>address1</code> property.
   * Line 1 in the street address.
   * @see javax.baja.util.BStreetAddress#address1
   */
  public String getAddress1() { return getString(address1); }
  
  /**
   * Set the <code>address1</code> property.
   * Line 1 in the street address.
   * @see javax.baja.util.BStreetAddress#address1
   */
  public void setAddress1(String v) { setString(address1,v,null); }

////////////////////////////////////////////////////////////////
// Property "address2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address2</code> property.
   * Line 2 in the street address, in case one line isn't
   * enough.
   * @see javax.baja.util.BStreetAddress#getAddress2
   * @see javax.baja.util.BStreetAddress#setAddress2
   */
  public static final Property address2 = newProperty(0, "",null);
  
  /**
   * Get the <code>address2</code> property.
   * Line 2 in the street address, in case one line isn't
   * enough.
   * @see javax.baja.util.BStreetAddress#address2
   */
  public String getAddress2() { return getString(address2); }
  
  /**
   * Set the <code>address2</code> property.
   * Line 2 in the street address, in case one line isn't
   * enough.
   * @see javax.baja.util.BStreetAddress#address2
   */
  public void setAddress2(String v) { setString(address2,v,null); }

////////////////////////////////////////////////////////////////
// Property "city"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>city</code> property.
   * @see javax.baja.util.BStreetAddress#getCity
   * @see javax.baja.util.BStreetAddress#setCity
   */
  public static final Property city = newProperty(0, "",null);
  
  /**
   * Get the <code>city</code> property.
   * @see javax.baja.util.BStreetAddress#city
   */
  public String getCity() { return getString(city); }
  
  /**
   * Set the <code>city</code> property.
   * @see javax.baja.util.BStreetAddress#city
   */
  public void setCity(String v) { setString(city,v,null); }

////////////////////////////////////////////////////////////////
// Property "state"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>state</code> property.
   * @see javax.baja.util.BStreetAddress#getState
   * @see javax.baja.util.BStreetAddress#setState
   */
  public static final Property state = newProperty(0, "",null);
  
  /**
   * Get the <code>state</code> property.
   * @see javax.baja.util.BStreetAddress#state
   */
  public String getState() { return getString(state); }
  
  /**
   * Set the <code>state</code> property.
   * @see javax.baja.util.BStreetAddress#state
   */
  public void setState(String v) { setString(state,v,null); }

////////////////////////////////////////////////////////////////
// Property "zip"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>zip</code> property.
   * @see javax.baja.util.BStreetAddress#getZip
   * @see javax.baja.util.BStreetAddress#setZip
   */
  public static final Property zip = newProperty(0, "",null);
  
  /**
   * Get the <code>zip</code> property.
   * @see javax.baja.util.BStreetAddress#zip
   */
  public String getZip() { return getString(zip); }
  
  /**
   * Set the <code>zip</code> property.
   * @see javax.baja.util.BStreetAddress#zip
   */
  public void setZip(String v) { setString(zip,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStreetAddress.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}