/*
 * Copyright 2010, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

/**
 * Validates a String to ensure it meets the requirements for a Station name
 *
 * @author		gjohnson
 * @creation 	23 Jul 2010
 * @version 	1
 * @since 		Niagara 3.5.29
 */
public final class BStationNameValidator
    extends BObject
    implements BIValidator
{
/*-
  class BStationNameValidator
  {
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.platform.ui.util.BStationNameValidator(2148978184)1.0$ @*/
/* Generated Fri Jul 23 15:19:54 BST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStationNameValidator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// BIValidator
////////////////////////////////////////////////////////////////  
  
  @Override
  public void validate(BObject value, Context cx)
      throws CannotValidateException
  {
    // Validate the String to ensure it can be used as the name of a Station
    String stationName = value.toString();
        
    if (!SlotPath.isValidName(stationName))
      throw new CannotValidateException(lex.getText("stationNameValidator.invalidName"));
    
    if (stationName.length() > maxStationNameLength)
      throw new CannotValidateException(lex.getText("stationNameValidator.nameTooLong"));
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  public static final BStationNameValidator INSTANCE = new BStationNameValidator(); 
  
  private static final Lexicon lex = Lexicon.make(BStationNameValidator.class);
  private static final int maxStationNameLength = 32;
}
