/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;

/**
 * BFolder is the standard BComponent used as a 
 * container for other BComponents.
 *
 * @author    Brian Frank
 * @creation  31 Aug 01
 * @version   $Revision: 12$ $Date: 3/28/05 9:23:16 AM EST$
 * @since     Baja 1.0
 */
public class BFolder
  extends BComponent
{

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFolder.class);
  
  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon()
  { 
    BValue dynamic = get("icon");
    if (dynamic instanceof BIcon)
      return (BIcon)dynamic;
    return icon;
  }  
  private static final BIcon icon = BIcon.std("folder.png");  

}
