/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;

/**
 * BConverter is used to convert from one BObject type
 * to another BObject type.  Converters are registered
 * in the module manifest and can be queried via the
 * Registry API.
 *
 * @author    Brian Frank
 * @creation  12 May 04
 * @version   $Revision: 3$ $Date: 5/27/04 12:16:26 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BConverter
  extends BStruct
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BConverter.class);
    
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////      
  
  /**
   * This method is used to give the converter a chance
   * to intialize its state based on a from and to type.
   */
  public void init(BObject from, BObject to)
  {
  }  
  
  /**
   * Convenience for <code>convert(from, to, null)</code>.
   */
  public final BObject convert(BObject from, BObject to)
  {
    return convert(from, to, null);
  }
  
  
  /**
   * Convert the first object to the second object and return
   * the result.  If the to-object is a complex then the conversion
   * should be in-place and the to-object should be returned.
   * If the to-object is a simple, then the return a new instance 
   * of the same type.
   */
  public abstract BObject convert(BObject from, BObject to, Context cx);
  
}
