/*
 * Copyright 2001, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.util;

import javax.baja.sys.*;

/**
 * BAbsTimeRange is a range of absolute times defining a period of
 * time.  The bounds of the range are inclusive.
 *
 * @author    John Sublett
 * @creation  16 Feb 2001
 * @version   $Revision: 6$ $Date: 2/6/03 11:21:41 AM EST$
 * @since     Baja 1.0
 */
public class BAbsTimeRange
  extends BStruct
{
  /*-
  
  class BAbsTimeRange
  {
    properties
    {
      startTime: BAbsTime
        -- The start time of the range, inclusive.
        default {[ BAbsTime.make(0) ]}
        
      endTime  : BAbsTime
        -- The end time of the range, inclusive.
        default {[ BAbsTime.END_OF_TIME ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BAbsTimeRange(2596841420)1.0$ @*/
/* Generated Mon Aug 20 17:18:33 BST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "startTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>startTime</code> property.
   * The start time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#getStartTime
   * @see javax.baja.util.BAbsTimeRange#setStartTime
   */
  public static final Property startTime = newProperty(0, BAbsTime.make(0),null);
  
  /**
   * Get the <code>startTime</code> property.
   * The start time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#startTime
   */
  public BAbsTime getStartTime() { return (BAbsTime)get(startTime); }
  
  /**
   * Set the <code>startTime</code> property.
   * The start time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#startTime
   */
  public void setStartTime(BAbsTime v) { set(startTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "endTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>endTime</code> property.
   * The end time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#getEndTime
   * @see javax.baja.util.BAbsTimeRange#setEndTime
   */
  public static final Property endTime = newProperty(0, BAbsTime.END_OF_TIME,null);
  
  /**
   * Get the <code>endTime</code> property.
   * The end time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#endTime
   */
  public BAbsTime getEndTime() { return (BAbsTime)get(endTime); }
  
  /**
   * Set the <code>endTime</code> property.
   * The end time of the range, inclusive.
   * @see javax.baja.util.BAbsTimeRange#endTime
   */
  public void setEndTime(BAbsTime v) { set(endTime,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAbsTimeRange.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   */
  public BAbsTimeRange()
  {
  }

  /**
   * Constructor with initial time range.
   *
   * @param startTime The beginning of the range.  The range
   *   includes the startTime.  If null, then startTime is
   *   set to the earliest possible time that can be represented
   *   by BAbsTime.
   *
   * @param endTime the end of the range.  The range includes
   *   the endTime.  If null, then endTime is set to the
   *   latest possible time that can be represented by BAbsTime.
   */
  public BAbsTimeRange(BAbsTime startTime, BAbsTime endTime)
  {
    if (startTime != null) setStartTime(startTime);
    if (endTime != null) setEndTime(endTime);
  }

  /**
   * Tests whether or not the specified time is within this range.
   * The range is inclusive of the endpoints.
   *
   * @param o A time to test for containment in the range.
   *
   * @return Returns true if the range contains the time, false otherwise.
   */
  public boolean includes(BAbsTime time)
  {
    return !time.isBefore(getStartTime()) && !time.isAfter(getEndTime());
  }
  
  /**
   * Get a string representation of the time range.
   */  
  @Override
  public String toString(Context ctx)
  {
    return getStartTime().toString(ctx) + " - " + getEndTime().toString(ctx);
  }
} 