/**
 * Copyright 2013 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.user;

import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.LexiconText;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import com.tridium.nre.security.PasswordStrength;

/**
 *
 * @author    Bill Smith
 * @creation  08 Feb 2012
 * @version   $Revision: 1$ $Date: 3/28/02 10:35:40 AM EST$
 * @since     Niagara AX 3.8
 */
public class BPasswordStrength
  extends BStruct
  implements IPropertyValidator
{
  /*-
  
  class BPasswordStrength
  {
    properties
    {
      minimumLength: int 
        -- minimum password length
        default {[ 10 ]}
        slotfacets {[ MIN = 0 ]}

      minimumLowerCase: int 
        -- minimum lower case letters
        default {[ 1 ]}
        slotfacets {[ MIN = 0 ]} 

      minimumUpperCase: int 
        -- minimum upper case letters
        default {[ 1 ]}
        slotfacets {[ MIN = 0 ]} 

      minimumDigits: int 
        -- minimum numbers
        default {[ 1 ]}
        slotfacets {[ MIN = 0 ]} 

      minimumSpecial: int 
        -- minimum numbers
        default {[ 0 ]}
        slotfacets {[ MIN = 0 ]} 
    }      
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.user.BPasswordStrength(3469334774)1.0$ @*/
/* Generated Thu Jun 01 09:57:25 EDT 2017 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "minimumLength"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code minimumLength} property.
   * minimum password length
   * @see #getMinimumLength
   * @see #setMinimumLength
   */
  public static final Property minimumLength = newProperty(0, 10, BFacets.make(BFacets.MIN, 0));
  
  /**
   * Get the {@code minimumLength} property.
   * minimum password length
   * @see #minimumLength
   */
  public int getMinimumLength() { return getInt(minimumLength); }
  
  /**
   * Set the {@code minimumLength} property.
   * minimum password length
   * @see #minimumLength
   */
  public void setMinimumLength(int v) { setInt(minimumLength, v, null); }

////////////////////////////////////////////////////////////////
// Property "minimumLowerCase"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code minimumLowerCase} property.
   * minimum lower case letters
   * @see #getMinimumLowerCase
   * @see #setMinimumLowerCase
   */
  public static final Property minimumLowerCase = newProperty(0, 1, BFacets.make(BFacets.MIN, 0));
  
  /**
   * Get the {@code minimumLowerCase} property.
   * minimum lower case letters
   * @see #minimumLowerCase
   */
  public int getMinimumLowerCase() { return getInt(minimumLowerCase); }
  
  /**
   * Set the {@code minimumLowerCase} property.
   * minimum lower case letters
   * @see #minimumLowerCase
   */
  public void setMinimumLowerCase(int v) { setInt(minimumLowerCase, v, null); }

////////////////////////////////////////////////////////////////
// Property "minimumUpperCase"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code minimumUpperCase} property.
   * minimum upper case letters
   * @see #getMinimumUpperCase
   * @see #setMinimumUpperCase
   */
  public static final Property minimumUpperCase = newProperty(0, 1, BFacets.make(BFacets.MIN, 0));
  
  /**
   * Get the {@code minimumUpperCase} property.
   * minimum upper case letters
   * @see #minimumUpperCase
   */
  public int getMinimumUpperCase() { return getInt(minimumUpperCase); }
  
  /**
   * Set the {@code minimumUpperCase} property.
   * minimum upper case letters
   * @see #minimumUpperCase
   */
  public void setMinimumUpperCase(int v) { setInt(minimumUpperCase, v, null); }

////////////////////////////////////////////////////////////////
// Property "minimumDigits"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code minimumDigits} property.
   * minimum numbers
   * @see #getMinimumDigits
   * @see #setMinimumDigits
   */
  public static final Property minimumDigits = newProperty(0, 1, BFacets.make(BFacets.MIN, 0));
  
  /**
   * Get the {@code minimumDigits} property.
   * minimum numbers
   * @see #minimumDigits
   */
  public int getMinimumDigits() { return getInt(minimumDigits); }
  
  /**
   * Set the {@code minimumDigits} property.
   * minimum numbers
   * @see #minimumDigits
   */
  public void setMinimumDigits(int v) { setInt(minimumDigits, v, null); }

////////////////////////////////////////////////////////////////
// Property "minimumSpecial"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code minimumSpecial} property.
   * minimum numbers
   * @see #getMinimumSpecial
   * @see #setMinimumSpecial
   */
  public static final Property minimumSpecial = newProperty(0, 0, BFacets.make(BFacets.MIN, 0));
  
  /**
   * Get the {@code minimumSpecial} property.
   * minimum numbers
   * @see #minimumSpecial
   */
  public int getMinimumSpecial() { return getInt(minimumSpecial); }
  
  /**
   * Set the {@code minimumSpecial} property.
   * minimum numbers
   * @see #minimumSpecial
   */
  public void setMinimumSpecial(int v) { setInt(minimumSpecial, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPasswordStrength.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BPasswordStrength()
  {    
  }
  
  public BPasswordStrength(int len, int lower, int upper, int digits, int special)
  {
    setMinimumLength(len);
    setMinimumLowerCase(lower);
    setMinimumUpperCase(upper);
    setMinimumDigits(digits);
    setMinimumSpecial(special);
  }

  /**
   * Creates a new BPasswordStrength using the information from the provided {@link PasswordStrength}
   * @param passwordStrength Used to create the BPasswordStrength.
   * @since Niagara 4.5
   */
  public BPasswordStrength(PasswordStrength passwordStrength)
  {
    setMinimumLength(passwordStrength.getMinimumLength());
    setMinimumLowerCase(passwordStrength.getMinimumLowerCase());
    setMinimumUpperCase(passwordStrength.getMinimumUpperCase());
    setMinimumDigits(passwordStrength.getMinimumDigits());
    setMinimumSpecial(passwordStrength.getMinimumSpecial());
  }


  /**
   * Returns true if the given password meets this object's strength requirements, otherwise false.
   *
   * @since Niagara 4.1
   *
   * @param messageConsumer if the strength requirements are unmet, a localizable message will be provided
   *                        to {@link Consumer#accept(Object)}
   */
  public boolean isPasswordValid(char[] password, Consumer<Localizable> messageConsumer)
  {
    if (messageConsumer == null) messageConsumer = context -> {};

    int lowerCase = 0;
    int upperCase = 0;
    int digits = 0;
    int special = 0;

    int len = password.length;
    for (char character : password)
    {
      if (Character.isLetter(character))
      {
        if (Character.isUpperCase(character))
        {
          upperCase++;
        }
        else
        {
          lowerCase++;
        }
      }
      else if (Character.isDigit(character))
      {
        digits++;
      }
      else
      {
        special++;
      }
    }

    if (len < getMinimumLength() ||
      digits < getMinimumDigits() ||
      lowerCase < getMinimumLowerCase() ||
      upperCase < getMinimumUpperCase() ||
      special < getMinimumSpecial())
    {
      List<Localizable> errors = new ArrayList<>();
      errors.add(LexiconText.toLocalizable("baja", "user.password.notStrong"));
      errors.addAll(getLocalizableRequirements());

      messageConsumer.accept(Localizable.concatenate("\n- ", errors));
      return false;
    }
    return true;
  }

  public void isPasswordValid(String password)
    throws Exception
  {
    AtomicReference<Localizable> messageRef = new AtomicReference<>();
    if (!isPasswordValid(password.toCharArray(), messageRef::set))
    {
      throw new BajaException(messageRef.get().toString(null));
    }
  }

  /**
   * This method validates that the password strength follows the minimum requirements
   * of this host. For example, a host in FIPS mode cannot have passwords short than
   * 14 characters.
   *
   * <p>Subclasses that override this method should take care to enforce these limits. Failure
   * to do so may result in unexpected errors when trying to log in, or when creating PBE keys.</p>
   *
   * @param validatable The validatable instance which contains the existing
   * and proposed state of a BComplex that needs to be validated.
   * @param context the Context for the pending set operation. Might be null.
   */
  @Override
  public void validateSet(Validatable validatable, Context context)
  {
    BComponent parent = this.getParentComponent();
    if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace))
    {
      BInteger proposedMinimumLength = (BInteger)validatable.getProposedValue(minimumLength);
      BInteger existingMinimumLength = (BInteger)validatable.getExistingValue(minimumLength);

      if (!proposedMinimumLength.equals(existingMinimumLength) &&
          proposedMinimumLength.getNumeric() < PasswordStrength.MINIMUM_ALLOWED_LENGTH)
      {
        throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[] {PasswordStrength.MINIMUM_ALLOWED_LENGTH});
      }
    }
  }

  /**
   * This method validates that the password strength follows the minimum requirements
   * of this host. For example, a host in FIPS mode cannot have passwords short than
   * 14 characters.
   *
   * <p>Subclasses that override this method should take care to enforce these limits. Failure
   * to do so may result in unexpected errors when trying to log in, or when creating PBE keys.</p>
   *
   * @param instance The BComplex instance for which there is
   * a pending set operation requiring validation.
   * @param property The property on the BComplex instance for
   * which there is a pending set operation.
   * @param newValue The pending new value for the property on the
   * BComplex instance which should be validated prior to commit.
   * @param context the Context for the pending set operation. Might be null.
   */
  @Override
  public void validateSet(BComplex instance, Property property, BValue newValue, Context context)
  {
    BComponent parent = this.getParentComponent();
    if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace))
    {
      BInteger proposedMinimumLength = (BInteger)newValue;

      if (minimumLength.equals(property) &&
          proposedMinimumLength.getNumeric() < PasswordStrength.MINIMUM_ALLOWED_LENGTH)
      {
        throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[] {PasswordStrength.MINIMUM_ALLOWED_LENGTH});
      }
    }
  }

  @Override
  public IPropertyValidator getPropertyValidator(Property[] properties, Context context)
  {
    return this;
  }

  @Override
  public IPropertyValidator getPropertyValidator(Property property, Context context)
  {
    return this;
  }

  public List<Localizable> getLocalizableRequirements()
  {
    List<Localizable> requirements = new ArrayList<>();

    if (getMinimumLength() > 0)
      requirements.add(LexiconText.toLocalizable("baja", "user.password.notLongEnough", getMinimumLength()));

    if (getMinimumDigits() > 0)
      requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughDigits", getMinimumDigits()));

    if (getMinimumLowerCase() > 0)
      requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughLowerCase", getMinimumLowerCase()));

    if (getMinimumUpperCase() > 0)
      requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughUpperCase", getMinimumUpperCase()));

    if (getMinimumSpecial() > 0)
      requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughSpecial", getMinimumSpecial()));

     return requirements;
  }

  public static final BPasswordStrength DEFAULT = new BPasswordStrength(PasswordStrength.DEFAULT);
  public static final BPasswordStrength FIPS_1 = new BPasswordStrength(PasswordStrength.FIPS_1);
  public static final BPasswordStrength STRONG = DEFAULT;
  public static final BPasswordStrength OFF     = new BPasswordStrength(0, 0, 0, 0, 0);
}
