/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BStruct is the base class for a BObject which has
 * one or more properties.  BStructs must only declare
 * properties which are typed as boolean, int, float,
 * String, BSimple, or other BStructs.  This means
 * that a BStruct may never have a BComponent property.
 * BStructs only support Property slots, never Actions
 * or Topics.
 * 
 * @author    Brian Frank
 * @creation  27 Nov 00
 * @version   $Revision: 8$ $Date: 3/28/05 9:23:12 AM EST$
 * @since     Baja 1.0
 */
public class BStruct
  extends BComplex
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Public no arg constructor.
   */
  public BStruct()
  {
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStruct.class);

}