/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BSingleton is a BObject which allocates exactly one 
 * instance per VM.  It provides a useful pattern for
 * typed libraries and factories.  BSingletons must 
 * provide a static final called INSTANCE which declares
 * the singleton's instance.  Subclasses should also
 * declare protected or private constructors to prevent
 * unwanted instances from being allocated.
 * 
 * @author    Brian Frank
 * @creation  11 Dec 02
 * @version   $Revision: 2$ $Date: 1/28/03 8:03:47 AM EST$
 * @since     Baja 1.0
 */
public abstract class BSingleton
  extends BObject
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Protected constructor.
   */
  protected BSingleton()
  {
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

   @Override
   public Type getType() { return TYPE; }
   public static final Type TYPE = Sys.loadType(BSingleton.class);

}