/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

import java.util.Set;
import java.util.TreeSet;
import javax.baja.naming.*;
import javax.baja.space.*;
import javax.baja.nav.*;
import javax.baja.registry.*;
import javax.baja.util.*;
import com.tridium.sys.module.*;

/**
 * BModuleSpace is a FileSpace used to manage the files
 * stored in module jars.
 *
 * @author    Brian Frank
 * @creation  14 Jan 03
 * @version   $Revision: 6$ $Date: 3/28/05 9:23:11 AM EST$
 * @since     Baja 1.0
 */
public class BModuleSpace
  extends BSpace
{

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BModuleSpace.class);

  public static final BModuleSpace INSTANCE = new BModuleSpace();
  
  static
  {
    BLocalHost.INSTANCE.addNavChild(INSTANCE);
    BLocalHost.INSTANCE.mountSpace(INSTANCE);
  }

////////////////////////////////////////////////////////////////
// Constructor 
////////////////////////////////////////////////////////////////

  /**
   * Private constructor.
   */
  private BModuleSpace()
  {
    super("modules", LexiconText.make("baja", "nav.modules"));
  }

////////////////////////////////////////////////////////////////
// BSpace
////////////////////////////////////////////////////////////////

  /**
   * Get the ord in session.
   */
  @Override
  public BOrd getOrdInSession()
  {
    return ordInSession;
  }

////////////////////////////////////////////////////////////////
// BINavNode
////////////////////////////////////////////////////////////////

  /**
   * We always have module children.
   */
  @Override
  public boolean hasNavChildren()
  {
    return true;
  }

  /**
   * Lazy load if necessary.
   */
  @Override
  public BINavNode getNavChild(String navName)
  {
    lazyLoad();
    return super.getNavChild(navName);
  }
  
  /**
   * Lazy load if necessary.
   */
  @Override
  public BINavNode[] getNavChildren()
  {
    lazyLoad();
    return super.getNavChildren();
  }

////////////////////////////////////////////////////////////////
// Load
////////////////////////////////////////////////////////////////  

  public void lazyLoad()
  {
    if (loaded) return;

    synchronized(loadLock)
    {
      if (loaded) return;
      loaded = true;
      
      // create a NavModule for each ModuleInfo

      Set<String> moduleNames = new TreeSet<>();
      for (ModuleInfo m : Sys.getRegistry().getModules())
      {
        moduleNames.add(m.getModuleName());
      }
      moduleNames.forEach(moduleName -> addNavChild(new BModuleNavNode(moduleName)));
    }
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("navOnly/modules.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  
  
  private BOrd ordInSession = BOrd.make("module:");
  private Object loadLock = new Object();
  private boolean loaded;  

}

