/*
 * Copyright 2017 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

import javax.baja.nre.annotations.NiagaraType;

/**
 * A marker interface that can be used by Niagara Types that can never be the target of a link
 * in Niagara.  Enforcement of unlinkable target types occurs in
 * {@link BComponent#checkLink(BComponent, Slot, Slot, Context)}
 * and
 * {@link BLink#activate()}
 *
 * @author   Scott Hoye
 * @creation 19 Apr 2017
 * @since    Niagara 4.4
 */
@NiagaraType
public interface BIUnlinkableTarget
  extends BInterface
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.sys.BILinkValidator(2979906276)1.0$ @*/
/* Generated Wed Apr 19 16:33:37 EDT 2017 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  Type TYPE = Sys.loadType(BIUnlinkableTarget.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
