/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BITime represents a time of day which is independent 
 * of any date in the past or future.
 *
 * @author    Mike Jarmy
 * @creation  17 Mar 10
 * @version   $Revision: 1$ $Date: 3/18/10 12:46:19 PM EDT$
 * @since     Baja 1.0
 */
public interface BITime
  extends BInterface
{
  /**
   * @return The hour: 0-23.
   */
  public int getHour();

  /**
   * @return The minute: 0-59.
   */
  public int getMinute();

  /**
   * @return The seconds: 0-59.
   */
  public int getSecond();

  /**
   * @return The millisecond: 0-999.
   */
  public int getMillisecond();
          
  /**
   * Milliseconds since the start of the day.
   */
  public long getTimeOfDayMillis();
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final Type TYPE = Sys.loadType(BITime.class);
}

