/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BIEnum is the interface implemented by BObjects 
 * which primarily represent an enumerated value.
 *
 * @author    Brian Frank
 * @creation  28 Sept 00
 * @version   $Revision: 5$ $Date: 3/31/04 9:02:22 AM EST$
 * @since     Baja 1.0
 */
public interface BIEnum
  extends BInterface
{ 

  /**
   * Get the enum value.
   */
  public BEnum getEnum();

  /**
   * Get facets for the enum value or BFacets.NULL if not applicable.
   */
  public BFacets getEnumFacets();

  public static final Type TYPE = Sys.loadType(BIEnum.class);
  
}
