/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * The BAction is the object type used to add
 * new actions to a BComponent.
 *
 * @author    Brian Frank
 * @creation  28 Sept 00
 * @version   $Revision: 14$ $Date: 3/28/05 9:23:09 AM EST$
 * @since     Baja 1.0
 */
public abstract class BAction
  extends BStruct
{ 

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAction.class);

  /**
   * Get the parameter type for the action, or
   * if the action takes no arguments return null.
   */
  public abstract Type getParameterType();
  
  /**
   * Get the default parameter to use for the 
   * action, or null if the action takes no
   * arguments.
   */
  public abstract BValue getParameterDefault();
  
  /**
   * Invoke the action on the specified target with
   * given argument array.
   */
  public abstract BValue invoke(BComponent target, BValue arg)
    throws Exception;

  /**
   * Get the return type for the action, or
   * null if the action doesn't return a value.
   */
  public abstract Type getReturnType();

  /**
   * Get the facets for the action or return BFacets.NULL.
   * Default returns BFacets.NULL.
   */
  public BFacets getFacets()
  {
    return BFacets.NULL;
  }

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("action.png");
  
}
